/*
 * Copyright (c) 2012, Francis Galiegue <fgaliegue@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.eel.kitchen.jsonschema.metaschema;

import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;

public final class SchemaURIs
{
    private static final JsonRef DRAFTV3;
    private static final JsonRef DRAFTV4;

    // No making new instances of this class
    private SchemaURIs()
    {
    }

    static {
        String uri;
        try {
            // Draft v3
            uri = "http://json-schema.org/draft-03/schema#";
            DRAFTV3 = JsonRef.fromString(uri);
            uri = "http://json-schema.org/draft-04/schema#";
            DRAFTV4 = JsonRef.fromString(uri);
        } catch (JsonSchemaException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static JsonRef draftV3()
    {
        return DRAFTV3;
    }

    public static JsonRef draftv4()
    {
        return DRAFTV4;
    }

    public static JsonRef defaultURI()
    {
        return draftV3();
    }
}
