/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.JsonLoader;

public abstract class ExampleBase {
    private static final String PKGBASE;
    private static final ObjectWriter WRITER;

    protected static void printReport(ValidationReport report) throws IOException {
        boolean success = report.isSuccess();
        System.out.println("Validation " + (success ? "succeeded" : "failed"));
        if (!success) {
            System.out.println("---- BEGIN REPORT ----");
            System.out.println(WRITER.writeValueAsString((Object)report.asJsonObject()));
            System.out.println("---- END REPORT ----");
        }
    }

    protected static JsonNode loadResource(String name) throws IOException {
        return JsonLoader.fromResource(PKGBASE + name);
    }

    static {
        String pkgName = ExampleBase.class.getPackage().getName();
        PKGBASE = "/" + pkgName.replace(".", "/");
        WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    }
}

