/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchema;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistries;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistry;
import org.eel.kitchen.jsonschema.metaschema.SchemaURIs;
import org.eel.kitchen.jsonschema.ref.JsonFragment;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.schema.AddressingMode;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.jsonschema.schema.SchemaNode;
import org.eel.kitchen.jsonschema.schema.SchemaRegistry;
import org.eel.kitchen.jsonschema.uri.URIDownloader;
import org.eel.kitchen.jsonschema.uri.URIManager;
import org.eel.kitchen.jsonschema.validator.JsonValidatorCache;

public final class JsonSchemaFactory {
    private final SchemaRegistry registry;
    private final JsonRef defaultSchemaURI;
    private final Map<JsonRef, JsonValidatorCache> validatorCaches;

    public static JsonSchemaFactory defaultFactory() {
        return new Builder().build();
    }

    private JsonSchemaFactory(Builder builder) {
        this.registry = new SchemaRegistry(builder.uriManager, builder.namespace, builder.addressingMode);
        this.defaultSchemaURI = builder.defaultSchemaURI;
        ImmutableMap.Builder cacheBuilder = ImmutableMap.builder();
        Map map = builder.keywordRegistries;
        for (Map.Entry entry : map.entrySet()) {
            JsonRef ref = (JsonRef)entry.getKey();
            JsonValidatorCache validatorCache = new JsonValidatorCache((KeywordRegistry)entry.getValue(), this.registry);
            cacheBuilder.put((Object)ref, (Object)validatorCache);
        }
        this.validatorCaches = cacheBuilder.build();
    }

    public JsonSchema fromSchema(JsonNode schema, String path) {
        SchemaContainer container = this.registry.register(schema);
        JsonNode subSchema = JsonFragment.fromFragment(path).resolve(container.getSchema());
        return this.createSchema(container, subSchema);
    }

    public JsonSchema fromSchema(JsonNode schema) {
        return this.fromSchema(schema, "");
    }

    public JsonSchema fromURI(URI uri, String path) throws JsonSchemaException {
        SchemaContainer container = this.registry.get(uri);
        JsonNode subSchema = JsonFragment.fromFragment(path).resolve(container.getSchema());
        return this.createSchema(container, subSchema);
    }

    public JsonSchema fromURI(URI uri) throws JsonSchemaException {
        return this.fromURI(uri, "");
    }

    public JsonSchema fromURI(String str) throws JsonSchemaException {
        return this.fromURI(URI.create(str), "");
    }

    public JsonSchema fromURI(String str, String path) throws JsonSchemaException {
        return this.fromURI(URI.create(str), path);
    }

    private JsonSchema createSchema(SchemaContainer container, JsonNode schema) {
        SchemaNode schemaNode = new SchemaNode(container, schema);
        JsonValidatorCache cache = this.getValidatorCache(container.getSchema());
        return new JsonSchema(cache, schemaNode);
    }

    private JsonValidatorCache getValidatorCache(JsonNode schema) {
        JsonRef ref;
        JsonNode node = schema.path("$schema");
        if (!node.isTextual()) {
            return this.validatorCaches.get(this.defaultSchemaURI);
        }
        try {
            ref = JsonRef.fromString(node.textValue());
            if (!this.validatorCaches.containsKey(ref)) {
                ref = this.defaultSchemaURI;
            }
        }
        catch (JsonSchemaException ignored) {
            ref = this.defaultSchemaURI;
        }
        return this.validatorCaches.get(ref);
    }

    public static final class Builder {
        private AddressingMode addressingMode;
        private JsonRef defaultSchemaURI;
        private KeywordRegistry defaultKeywordRegistry;
        private final Map<JsonRef, KeywordRegistry> keywordRegistries;
        private final URIManager uriManager;
        private URI namespace = URI.create("");

        public Builder() {
            this.uriManager = new URIManager();
            this.addressingMode = AddressingMode.CANONICAL;
            this.defaultSchemaURI = SchemaURIs.defaultURI();
            this.defaultKeywordRegistry = KeywordRegistries.defaultRegistry();
            this.keywordRegistries = Maps.newHashMap();
            this.keywordRegistries.put(this.defaultSchemaURI, this.defaultKeywordRegistry);
            this.keywordRegistries.put(SchemaURIs.draftV3HyperSchemaURI(), KeywordRegistries.draftV3HyperSchemaRegistry());
            this.keywordRegistries.put(SchemaURIs.draftV4(), KeywordRegistries.draftV4());
        }

        public Builder registerScheme(String scheme, URIDownloader downloader) {
            this.uriManager.registerScheme(scheme, downloader);
            return this;
        }

        public Builder unregisterScheme(String scheme) {
            this.uriManager.unregisterScheme(scheme);
            return this;
        }

        public Builder addressingMode(AddressingMode addressingMode) {
            this.addressingMode = addressingMode;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = URI.create(namespace);
            return this;
        }

        public Builder addRedirection(String from, String to) {
            this.uriManager.addRedirection(from, to);
            return this;
        }

        public Builder addKeywordRegistry(JsonRef schemaURI, KeywordRegistry keywordRegistry, boolean byDefault) {
            Preconditions.checkNotNull((Object)schemaURI, (Object)"schema URI cannot be null");
            Preconditions.checkNotNull((Object)keywordRegistry, (Object)"keyword registry cannot be null");
            this.keywordRegistries.put(schemaURI, keywordRegistry);
            if (byDefault) {
                this.defaultSchemaURI = schemaURI;
                this.defaultKeywordRegistry = keywordRegistry;
            }
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this);
        }
    }
}

