/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;

public final class PatternPropertiesSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker instance = new PatternPropertiesSyntaxChecker();

    private PatternPropertiesSyntaxChecker() {
        super("patternProperties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        HashSet regexes = Sets.newHashSet((Iterator)node.fieldNames());
        for (String regex : Ordering.natural().sortedCopy((Iterable)regexes)) {
            msg.clearInfo().addInfo("key", regex);
            if (!RhinoHelper.regexIsValid(regex)) {
                msg.setMessage("key is not a valid ECMA 262 regex");
                messages.add(msg.build());
                continue;
            }
            NodeType type = NodeType.getNodeType(node.get(regex));
            if (type == NodeType.OBJECT) continue;
            msg.setMessage("illegal key value").addInfo("found", type).addInfo("expected", NodeType.OBJECT);
            messages.add(msg.build());
        }
    }
}

