/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class DraftV3DependenciesSyntaxChecker
extends AbstractSyntaxChecker {
    private static final EnumSet<NodeType> VALID_DEPENDENCY_TYPES = EnumSet.of(NodeType.OBJECT, NodeType.ARRAY, NodeType.STRING);
    private static final SyntaxChecker instance = new DraftV3DependenciesSyntaxChecker();

    private DraftV3DependenciesSyntaxChecker() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return instance;
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        HashSet fields = Sets.newHashSet((Iterator)node.fieldNames());
        for (String field : Ordering.natural().sortedCopy((Iterable)fields)) {
            msg.clearInfo().addInfo("property", field);
            JsonNode element = node.get(field);
            NodeType type = NodeType.getNodeType(element);
            if (type == NodeType.OBJECT || type == NodeType.STRING) continue;
            if (type != NodeType.ARRAY) {
                msg.addInfo("found", type).addInfo("expected", VALID_DEPENDENCY_TYPES).setMessage("dependency value has incorrect type");
                messages.add(msg.build());
                continue;
            }
            int size = element.size();
            for (int index = 0; index < size; ++index) {
                type = NodeType.getNodeType(element.get(index));
                if (type == NodeType.STRING) continue;
                msg.addInfo("index", index).addInfo("found", type).addInfo("expected", NodeType.STRING).setMessage("array dependency value has incorrect type");
                messages.add(msg.build());
            }
        }
    }
}

