/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.uri;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.report.Domain;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.uri.DefaultURIDownloader;
import org.eel.kitchen.jsonschema.uri.ResourceURIDownloader;
import org.eel.kitchen.jsonschema.uri.URIDownloader;
import org.eel.kitchen.jsonschema.util.CustomJsonNodeFactory;

public final class URIManager {
    private static final ObjectMapper MAPPER = CustomJsonNodeFactory.getMapper();
    private final Map<String, URIDownloader> downloaders = Maps.newHashMap();
    private final Map<URI, URI> URIRedirections = Maps.newHashMap();

    public URIManager() {
        this.downloaders.put("http", DefaultURIDownloader.getInstance());
        this.downloaders.put("ftp", DefaultURIDownloader.getInstance());
        this.downloaders.put("file", DefaultURIDownloader.getInstance());
        this.downloaders.put("jar", DefaultURIDownloader.getInstance());
        this.downloaders.put("resource", ResourceURIDownloader.getInstance());
    }

    public void registerScheme(String scheme, URIDownloader downloader) {
        Preconditions.checkNotNull((Object)scheme, (Object)"scheme is null");
        Preconditions.checkArgument((!scheme.isEmpty() ? 1 : 0) != 0, (Object)"scheme is empty");
        try {
            new URI(scheme, "x", "y");
        }
        catch (URISyntaxException ignored) {
            throw new IllegalArgumentException("illegal scheme \"" + scheme + '\"');
        }
        this.downloaders.put(scheme, downloader);
    }

    public void unregisterScheme(String scheme) {
        Preconditions.checkNotNull((Object)scheme, (Object)"scheme is null");
        this.downloaders.remove(scheme);
    }

    public void addRedirection(String from, String to) {
        URI destURI;
        URI sourceURI;
        JsonRef ref;
        Preconditions.checkNotNull((Object)from, (Object)"source URI is null");
        Preconditions.checkNotNull((Object)to, (Object)"destination URI is null");
        String errmsg = "source URI " + from + " is not an absolute JSON reference";
        try {
            ref = JsonRef.fromString(from);
            Preconditions.checkArgument((boolean)ref.isAbsolute(), (Object)errmsg);
            sourceURI = ref.getLocator();
        }
        catch (JsonSchemaException ignored) {
            throw new IllegalArgumentException(errmsg);
        }
        errmsg = "destination URI " + to + " is not an absolute JSON reference";
        try {
            ref = JsonRef.fromString(to);
            Preconditions.checkArgument((boolean)ref.isAbsolute(), (Object)errmsg);
            destURI = ref.getLocator();
        }
        catch (JsonSchemaException ignored) {
            throw new IllegalArgumentException(errmsg);
        }
        this.URIRedirections.put(sourceURI, destURI);
    }

    public JsonNode getContent(URI uri) throws JsonSchemaException {
        InputStream in;
        Preconditions.checkNotNull((Object)uri, (Object)"null URI");
        URI target = this.URIRedirections.containsKey(uri) ? this.URIRedirections.get(uri) : uri;
        Message.Builder msg = Domain.REF_RESOLVING.newMessage().setKeyword("N/A").addInfo("uri", target).setFatal(true);
        if (!target.isAbsolute()) {
            throw new JsonSchemaException(msg.setMessage("URI is not absolute").build());
        }
        String scheme = target.getScheme();
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            msg.setMessage("cannot handle scheme").addInfo("scheme", scheme);
            throw new JsonSchemaException(msg.build());
        }
        try {
            in = downloader.fetch(target);
        }
        catch (IOException e) {
            msg.setMessage("cannot fetch content from URI");
            throw new JsonSchemaException(msg.build(), e);
        }
        try {
            return MAPPER.readTree(in);
        }
        catch (IOException e) {
            msg.setMessage("content fetched from URI is not valid JSON");
            throw new JsonSchemaException(msg.build(), e);
        }
    }
}

