/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eel.kitchen.jsonschema.util.CustomJsonNodeFactory;

public final class JacksonUtils {
    private static final JsonNode EMPTY_SCHEMA = EmptySchema.access$000();

    private JacksonUtils() {
    }

    public static Map<String, JsonNode> nodeToMap(JsonNode node) {
        HashMap ret = Maps.newHashMap();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static JsonNode emptySchema() {
        return EMPTY_SCHEMA;
    }

    private static final class EmptySchema
    extends ObjectNode {
        private static final JsonNode instance = new EmptySchema();

        private static JsonNode getInstance() {
            return instance;
        }

        private EmptySchema() {
            super(CustomJsonNodeFactory.getInstance());
        }

        public ObjectNode with(String propertyName) {
            throw new UnsupportedOperationException();
        }

        public ArrayNode withArray(String propertyName) {
            throw new UnsupportedOperationException();
        }

        public JsonNode put(String fieldName, JsonNode value) {
            throw new UnsupportedOperationException();
        }

        public JsonNode putAll(Map<String, JsonNode> properties) {
            throw new UnsupportedOperationException();
        }

        public JsonNode putAll(ObjectNode other) {
            throw new UnsupportedOperationException();
        }

        public ArrayNode putArray(String fieldName) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode putObject(String fieldName) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode putPOJO(String fieldName, Object pojo) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode putNull(String fieldName) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, int v) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, Integer value) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, long v) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, Long value) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, float v) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, Float value) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, double v) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, Double value) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, BigDecimal v) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, String v) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, boolean v) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, Boolean value) {
            throw new UnsupportedOperationException();
        }

        public ObjectNode put(String fieldName, byte[] v) {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ JsonNode access$000() {
            return EmptySchema.getInstance();
        }
    }
}

