/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class DraftV4PropertiesSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV4PropertiesSyntaxChecker();

    private DraftV4PropertiesSyntaxChecker() {
        super("properties", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        HashSet fields = Sets.newHashSet((Iterator)node.fieldNames());
        for (String field : Ordering.natural().sortedCopy((Iterable)fields)) {
            msg.addInfo("key", field);
            JsonNode element = node.get(field);
            NodeType type = NodeType.getNodeType(element);
            if (type == NodeType.OBJECT) continue;
            msg.setMessage("key value has incorrect type").addInfo("expected", NodeType.OBJECT).addInfo("found", type);
            messages.add(msg.build());
        }
    }
}

