/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;
import org.eel.kitchen.jsonschema.schema.SchemaNode;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidatorCache;

public final class ValidationContext {
    private final JsonValidatorCache cache;
    private SchemaContainer container;

    public ValidationContext(JsonValidatorCache cache) {
        this.cache = cache;
    }

    SchemaContainer getContainer() {
        return this.container;
    }

    void setContainer(SchemaContainer container) {
        this.container = container;
    }

    public FormatAttribute getFormat(String fmt) {
        return this.cache.getFormatAttributes().get(fmt);
    }

    public JsonValidator newValidator(JsonNode node) {
        SchemaNode schemaNode = new SchemaNode(this.container, node);
        return this.cache.getValidator(schemaNode);
    }

    public String toString() {
        return "current: " + this.container;
    }
}

