/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class PositiveIntegerSyntaxChecker
extends AbstractSyntaxChecker {
    public PositiveIntegerSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, new NodeType[0]);
    }

    @Override
    public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        msg.addInfo("found", node);
        if (!node.canConvertToInt()) {
            msg.setMessage("integer value is too large").addInfo("max", Integer.MAX_VALUE);
            messages.add(msg.build());
            return;
        }
        if (node.intValue() < 0) {
            messages.add(msg.setMessage("value cannot be negative").build());
        }
    }
}

