/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class JsonNodeEquivalence
extends Equivalence<JsonNode> {
    private static final int ZERO_HASHCODE = new DecimalNode(BigDecimal.ZERO).hashCode();
    private static final Equivalence<JsonNode> INSTANCE = new JsonNodeEquivalence();

    private JsonNodeEquivalence() {
    }

    public static Equivalence<JsonNode> getInstance() {
        return INSTANCE;
    }

    protected boolean doEquivalent(JsonNode a, JsonNode b) {
        NodeType typeB;
        if (a.isNumber() && b.isNumber()) {
            return JsonNodeEquivalence.numEquals(a, b);
        }
        NodeType typeA = NodeType.getNodeType(a);
        if (typeA != (typeB = NodeType.getNodeType(b))) {
            return false;
        }
        if (!a.isContainerNode()) {
            return a.equals((Object)b);
        }
        if (a.size() != b.size()) {
            return false;
        }
        return typeA == NodeType.ARRAY ? this.arrayEquals(a, b) : this.objectEquals(a, b);
    }

    protected int doHash(JsonNode t) {
        if (t.isNumber()) {
            BigDecimal decimal = t.decimalValue();
            return decimal.compareTo(BigDecimal.ZERO) == 0 ? ZERO_HASHCODE : decimal.hashCode();
        }
        if (!t.isContainerNode()) {
            return t.hashCode();
        }
        int ret = 0;
        if (t.isArray()) {
            for (JsonNode element : t) {
                ret = 31 * ret + this.doHash(element);
            }
            return ret;
        }
        Iterator iterator = t.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret = 31 * ret + (((String)entry.getKey()).hashCode() ^ this.doHash((JsonNode)entry.getValue()));
        }
        return ret;
    }

    private static boolean numEquals(JsonNode a, JsonNode b) {
        if (a.isIntegralNumber() && b.isIntegralNumber()) {
            return a.equals((Object)b);
        }
        return a.decimalValue().compareTo(b.decimalValue()) == 0;
    }

    private boolean arrayEquals(JsonNode a, JsonNode b) {
        int size = a.size();
        for (int i = 0; i < size; ++i) {
            if (this.doEquivalent(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean objectEquals(JsonNode a, JsonNode b) {
        HashSet keys = Sets.newHashSet((Iterator)a.fieldNames());
        HashSet set = Sets.newHashSet((Iterator)b.fieldNames());
        if (!set.equals(keys)) {
            return false;
        }
        for (String key : keys) {
            if (this.doEquivalent(a.get(key), b.get(key))) continue;
            return false;
        }
        return true;
    }
}

