/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.ref.JsonPointer;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.RhinoHelper;
import org.eel.kitchen.jsonschema.util.jackson.JacksonUtils;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

final class ObjectValidator
implements JsonValidator {
    private final JsonNode additionalProperties;
    private final Map<String, JsonNode> properties;
    private final Map<String, JsonNode> patternProperties;

    ObjectValidator(JsonNode schema) {
        JsonNode node = schema.path("additionalProperties");
        this.additionalProperties = node.isObject() ? node : JacksonUtils.emptyObject();
        node = schema.path("properties");
        this.properties = node.isObject() ? JacksonUtils.asMap(node) : Collections.emptyMap();
        node = schema.path("patternProperties");
        this.patternProperties = node.isObject() ? JacksonUtils.asMap(node) : Collections.emptyMap();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        JsonPointer pwd = report.getPath();
        Map<String, JsonNode> map = JacksonUtils.asMap(instance);
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            report.setPath(pwd.append(entry.getKey()));
            if (this.validateOne(context, report, entry)) continue;
            break;
        }
        report.setPath(pwd);
    }

    private boolean validateOne(ValidationContext context, ValidationReport report, Map.Entry<String, JsonNode> entry) {
        String key = entry.getKey();
        JsonNode value = entry.getValue();
        Set<JsonNode> subSchemas = this.getSchemas(key);
        for (JsonNode subSchema : subSchemas) {
            JsonValidator validator = context.newValidator(subSchema);
            validator.validate(context, report, value);
            if (!report.hasFatalError()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    Set<JsonNode> getSchemas(String key) {
        HashSet ret = Sets.newHashSet();
        if (this.properties.containsKey(key)) {
            ret.add(this.properties.get(key));
        }
        for (Map.Entry<String, JsonNode> entry : this.patternProperties.entrySet()) {
            if (!RhinoHelper.regMatch(entry.getKey(), key)) continue;
            ret.add(entry.getValue());
        }
        if (ret.isEmpty()) {
            ret.add(this.additionalProperties);
        }
        return ImmutableSet.copyOf((Collection)ret);
    }
}

