/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.eel.kitchen.jsonschema.keyword.NumericKeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;

public abstract class DivisorKeywordValidator
extends NumericKeywordValidator {
    protected DivisorKeywordValidator(String keyword, JsonNode schema) {
        super(keyword, schema);
    }

    @Override
    protected final void validateLong(ValidationReport report, JsonNode instance) {
        long longValue;
        long instanceValue = instance.longValue();
        long remainder = instanceValue % (longValue = this.number.longValue());
        if (remainder == 0L) {
            return;
        }
        Message.Builder msg = this.newMsg().setMessage("number is not a multiple of " + this.keyword).addInfo("value", instance).addInfo("divisor", this.number);
        report.addMessage(msg.build());
    }

    @Override
    protected final void validateDecimal(ValidationReport report, JsonNode instance) {
        BigDecimal decimalValue;
        BigDecimal instanceValue = instance.decimalValue();
        BigDecimal remainder = instanceValue.remainder(decimalValue = this.number.decimalValue());
        if (remainder.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        Message.Builder msg = this.newMsg().setMessage("number is not a multiple of " + this.keyword).addInfo("value", instance).addInfo("divisor", this.number);
        report.addMessage(msg.build());
    }
}

