/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.PositiveIntegerKeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class MaxLengthKeywordValidator
extends PositiveIntegerKeywordValidator {
    public MaxLengthKeywordValidator(JsonNode schema) {
        super("maxLength", schema, NodeType.STRING);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        int len = instance.textValue().length();
        if (len <= this.intValue) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo(this.keyword, this.intValue).addInfo("found", len).setMessage("string is too long");
        report.addMessage(msg.build());
    }
}

