/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class AdditionalPropertiesKeywordValidator
extends KeywordValidator {
    private static final Joiner TOSTRING_JOINER = Joiner.on((String)"; or ");
    private final boolean additionalOK;
    private final Set<String> properties;
    private final Set<String> patternProperties;

    public AdditionalPropertiesKeywordValidator(JsonNode schema) {
        super("additionalProperties", NodeType.OBJECT);
        this.additionalOK = schema.get(this.keyword).asBoolean(true);
        if (this.additionalOK) {
            this.properties = Collections.emptySet();
            this.patternProperties = Collections.emptySet();
            return;
        }
        this.properties = ImmutableSet.copyOf((Iterator)schema.path("properties").fieldNames());
        this.patternProperties = ImmutableSet.copyOf((Iterator)schema.path("patternProperties").fieldNames());
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
        fields.removeAll(this.properties);
        HashSet tmp = Sets.newHashSet();
        for (String field : fields) {
            for (String regex : this.patternProperties) {
                if (!RhinoHelper.regMatch(regex, field)) continue;
                tmp.add(field);
            }
        }
        fields.removeAll(tmp);
        if (fields.isEmpty()) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("unwanted", Ordering.natural().sortedCopy((Iterable)fields)).setMessage("additional properties not permitted");
        report.addMessage(msg.build());
    }

    @Override
    public boolean alwaysTrue() {
        return this.additionalOK;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.keyword + ": ");
        if (this.additionalOK) {
            return sb.append("allowed").toString();
        }
        sb.append("none");
        if (this.properties.isEmpty() && this.patternProperties.isEmpty()) {
            return sb.toString();
        }
        sb.append(", unless: ");
        LinkedHashSet further = Sets.newLinkedHashSet();
        if (!this.properties.isEmpty()) {
            further.add("one property is any of: " + this.properties);
        }
        if (!this.patternProperties.isEmpty()) {
            further.add("a property matches any regex among: " + this.patternProperties);
        }
        sb.append(TOSTRING_JOINER.join((Iterable)further));
        return sb.toString();
    }
}

