/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.schema.SchemaContainer;

public final class InlineSchemaContainer
extends SchemaContainer {
    private final Map<JsonRef, JsonNode> schemas;

    InlineSchemaContainer(JsonNode schema) {
        super(InlineSchemaContainer.extractLocator(schema).toURI(), schema);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.locator, (Object)this.schema);
        InlineSchemaContainer.fillURIMap(this.locator, this.schema, (ImmutableMap.Builder<JsonRef, JsonNode>)builder);
        this.schemas = builder.build();
    }

    @Override
    public boolean contains(JsonRef other) {
        return this.schemas.containsKey(other) || this.locator.contains(other);
    }

    @Override
    public JsonNode resolve(JsonRef ref) {
        return this.schemas.containsKey(ref) ? this.schemas.get(ref) : ref.getFragment().resolve(this.schema);
    }

    private static JsonRef extractLocator(JsonNode node) {
        try {
            return InlineSchemaContainer.refFromNode(node.path("id"));
        }
        catch (JsonSchemaException ignored) {
            return JsonRef.emptyRef();
        }
    }

    private static void fillURIMap(JsonRef baseRef, JsonNode node, ImmutableMap.Builder<JsonRef, JsonNode> builder) {
        if (!node.isObject()) {
            return;
        }
        for (JsonNode child : node) {
            if (child.has("id")) {
                try {
                    JsonRef idRef = InlineSchemaContainer.refFromNode(child.get("id"));
                    JsonRef resolvedRef = baseRef.resolve(idRef);
                    builder.put((Object)resolvedRef, (Object)InlineSchemaContainer.cleanup(child));
                }
                catch (JsonSchemaException ignored) {
                    // empty catch block
                }
            }
            InlineSchemaContainer.fillURIMap(baseRef, InlineSchemaContainer.cleanup(child), builder);
        }
    }

    private static JsonRef refFromNode(JsonNode node) throws JsonSchemaException {
        return node.isTextual() ? JsonRef.fromString(node.textValue()) : JsonRef.emptyRef();
    }
}

