/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Domain;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.util.NodeType;

public abstract class AbstractSyntaxChecker
implements SyntaxChecker {
    protected final String keyword;
    private final EnumSet<NodeType> validTypes;

    protected AbstractSyntaxChecker(String keyword, NodeType type, NodeType ... types) {
        this.keyword = keyword;
        this.validTypes = EnumSet.of(type, types);
    }

    @Override
    public final void checkSyntax(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        NodeType nodeType = NodeType.getNodeType(schema.get(this.keyword));
        if (!this.validTypes.contains((Object)nodeType)) {
            messages.add(this.newMsg().setMessage("incorrect type for value").addInfo("expected", this.validTypes).addInfo("found", nodeType).build());
            return;
        }
        this.checkValue(validator, messages, schema);
    }

    public abstract void checkValue(SyntaxValidator var1, List<Message> var2, JsonNode var3);

    protected final Message.Builder newMsg() {
        return Domain.SYNTAX.newMessage().setKeyword(this.keyword);
    }
}

