/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.common;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;

public final class PatternSyntaxChecker
extends AbstractSyntaxChecker {
    private static final PatternSyntaxChecker INSTANCE = new PatternSyntaxChecker();

    public static PatternSyntaxChecker getInstance() {
        return INSTANCE;
    }

    private PatternSyntaxChecker() {
        super("pattern", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        String value = schema.get(this.keyword).textValue();
        if (RhinoHelper.regexIsValid(value)) {
            return;
        }
        messages.add(this.newMsg().addInfo("found", value).setMessage("pattern is not a valid ECMA 262 regex").build());
    }
}

