/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class SchemaArraySyntaxChecker
extends AbstractSyntaxChecker {
    public SchemaArraySyntaxChecker(String keyword) {
        super(keyword, NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        Message.Builder msg = this.newMsg();
        int size = node.size();
        if (size == 0) {
            msg.setMessage("array must have at least one element");
            messages.add(msg.build());
            return;
        }
        for (int index = 0; index < size; ++index) {
            JsonNode subSchema = node.get(index);
            NodeType type = NodeType.getNodeType(subSchema);
            if (type != NodeType.OBJECT) {
                msg.setMessage("incorrect type for array element").addInfo("index", index).addInfo("found", type).addInfo("expected", NodeType.OBJECT);
                messages.add(msg.build());
                continue;
            }
            validator.validate(messages, subSchema);
        }
    }
}

