/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax.hyperschema.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.AbstractSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxValidator;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class FragmentResolutionSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new FragmentResolutionSyntaxChecker();
    private static final Set<String> PROTOCOLS = ImmutableSet.of((Object)"slash-delimited", (Object)"dot-delimited");

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private FragmentResolutionSyntaxChecker() {
        super("fragmentResolution", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        String protocol = schema.get(this.keyword).textValue();
        if (PROTOCOLS.contains(protocol)) {
            return;
        }
        messages.add(this.newMsg().addInfo("possible-values", PROTOCOLS).setMessage("unknown fragment resolution protocol").addInfo("found", protocol).build());
    }
}

