/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro.example;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.Key;
import org.kitesdk.data.RandomAccessDataset;
import org.kitesdk.data.hbase.HBaseDatasetRepository;
import org.kitesdk.data.hbase.avro.example.UserActionsModel2;
import org.kitesdk.data.hbase.avro.example.UserProfileActionsModel2;
import org.kitesdk.data.hbase.avro.example.UserProfileModel2;

public class UserProfileDatasetExample {
    private final RandomAccessDataset<UserProfileModel2> userProfileDataset;
    private final RandomAccessDataset<UserActionsModel2> userActionsDataset;
    private final RandomAccessDataset<UserProfileActionsModel2> userProfileActionsDataset;

    public UserProfileDatasetExample() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        HBaseAdmin admin = new HBaseAdmin(conf);
        if (admin.tableExists("kite_example_user_profiles")) {
            admin.disableTable("kite_example_user_profiles");
            admin.deleteTable("kite_example_user_profiles");
        }
        HBaseDatasetRepository repo = new HBaseDatasetRepository.Builder().configuration(conf).build();
        DatasetDescriptor userProfileDatasetDescriptor = new DatasetDescriptor.Builder().schema(UserProfileModel2.SCHEMA$).build();
        this.userProfileDataset = repo.create("default", "kite_example_user_profiles.UserProfileModel2", userProfileDatasetDescriptor);
        DatasetDescriptor userActionsDatasetDescriptor = new DatasetDescriptor.Builder().schema(UserActionsModel2.SCHEMA$).build();
        this.userActionsDataset = repo.create("default", "kite_example_user_profiles.UserActionsModel2", userActionsDatasetDescriptor);
        DatasetDescriptor userProfileActionsDatasetDescriptor = new DatasetDescriptor.Builder().schema(UserProfileActionsModel2.SCHEMA$).build();
        this.userProfileActionsDataset = repo.create("default", "kite_example_user_profiles.UserProfileActionsProtocol2", userProfileActionsDatasetDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printUserProfies() {
        DatasetReader reader = this.userProfileDataset.newReader();
        try {
            for (UserProfileModel2 userProfile : reader) {
                System.out.println(userProfile.toString());
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printUserProfileActionsForLastName(String lastName) {
        DatasetReader reader = this.userProfileActionsDataset.newReader();
        try {
            for (UserProfileActionsModel2 entity : reader) {
                UserProfileModel2 userProfile = entity.getUserProfileModel();
                if (!userProfile.getLastName().equals(lastName)) continue;
                System.out.println(entity.toString());
            }
        }
        finally {
            reader.close();
        }
    }

    public void create(String firstName, String lastName, boolean married) {
        long ts = System.currentTimeMillis();
        UserProfileModel2 profileModel = UserProfileModel2.newBuilder().setFirstName(firstName).setLastName(lastName).setMarried(married).setCreated(ts).build();
        UserActionsModel2 actionsModel = UserActionsModel2.newBuilder().setFirstName(firstName).setLastName(lastName).setActions(new HashMap<String, String>()).build();
        actionsModel.getActions().put("profile_created", Long.toString(ts));
        UserProfileActionsModel2 profileActionsModel = UserProfileActionsModel2.newBuilder().setUserProfileModel(profileModel).setUserActionsModel(actionsModel).build();
        if (!this.userProfileActionsDataset.put((Object)profileActionsModel)) {
            System.out.println("Creating a new user profile failed due to a write conflict.");
        }
    }

    public void updateUserProfile(String firstName, String lastName, boolean married) {
        long ts = System.currentTimeMillis();
        Key key = new Key.Builder(this.userProfileActionsDataset).add("firstName", (Object)firstName).add("lastName", (Object)lastName).build();
        UserProfileActionsModel2 profileActionsModel = (UserProfileActionsModel2)((Object)this.userProfileActionsDataset.get(key));
        UserProfileActionsModel2 updatedProfileActionsModel = UserProfileActionsModel2.newBuilder(profileActionsModel).setUserProfileModel(UserProfileModel2.newBuilder(profileActionsModel.getUserProfileModel()).setMarried(married).build()).build();
        updatedProfileActionsModel.getUserActionsModel().getActions().put("profile_updated", Long.toString(ts));
        if (!this.userProfileActionsDataset.put((Object)profileActionsModel)) {
            System.out.println("Updating the user profile failed due to a write conflict");
        }
    }

    public void addAction(String firstName, String lastName, String actionType, String actionValue) {
        UserActionsModel2 actionsModel = UserActionsModel2.newBuilder().setFirstName(firstName).setLastName(lastName).setActions(new HashMap<String, String>()).build();
        actionsModel.getActions().put(actionType, actionValue);
        this.userActionsDataset.put((Object)actionsModel);
    }

    public static void main(String[] args) throws Exception {
        UserProfileDatasetExample example = new UserProfileDatasetExample();
        example.create("John", "Doe", true);
        example.create("Jane", "Doe", false);
        example.create("Foo", "Bar", false);
        example.printUserProfies();
        example.addAction("Jane", "Doe", "last_login", "2013-07-30 00:00:00");
        example.addAction("Jane", "Doe", "ad_click", "example.com_ad_id");
        example.addAction("Foo", "Bar", "last_login", "2013-07-30 00:00:00");
        example.printUserProfileActionsForLastName("Doe");
        example.updateUserProfile("Jane", "Doe", true);
        example.printUserProfileActionsForLastName("Doe");
    }
}

