/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnDecoder
extends Decoder {
    private final BinaryDecoder wrappedDecoder;
    private final InputStream in;
    private final DataInputStream dataIn;

    public ColumnDecoder(InputStream in) {
        this.in = in;
        this.wrappedDecoder = new DecoderFactory().binaryDecoder(in, null);
        this.dataIn = new DataInputStream(in);
    }

    public void readNull() throws IOException {
        this.wrappedDecoder.readNull();
    }

    public boolean readBoolean() throws IOException {
        return this.wrappedDecoder.readBoolean();
    }

    public int readInt() throws IOException {
        byte[] b = new byte[4];
        this.dataIn.readFully(b);
        return Bytes.toInt((byte[])b);
    }

    public long readLong() throws IOException {
        byte[] b = new byte[8];
        this.dataIn.readFully(b);
        return Bytes.toLong((byte[])b);
    }

    public float readFloat() throws IOException {
        return this.wrappedDecoder.readFloat();
    }

    public double readDouble() throws IOException {
        return this.wrappedDecoder.readDouble();
    }

    public Utf8 readString(Utf8 old) throws IOException {
        int bytesAvailable = this.in.available();
        byte[] bytes = new byte[bytesAvailable];
        this.in.read(bytes);
        return new Utf8(bytes);
    }

    public String readString() throws IOException {
        return this.readString(null).toString();
    }

    public void skipString() throws IOException {
        int bytesAvailable = this.in.available();
        this.in.skip(bytesAvailable);
    }

    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        return this.wrappedDecoder.readBytes(old);
    }

    public void skipBytes() throws IOException {
        this.wrappedDecoder.skipBytes();
    }

    public void readFixed(byte[] bytes, int start, int length) throws IOException {
        this.wrappedDecoder.readFixed(bytes, start, length);
    }

    public void skipFixed(int length) throws IOException {
        this.wrappedDecoder.skipFixed(length);
    }

    public int readEnum() throws IOException {
        return this.wrappedDecoder.readEnum();
    }

    public long readArrayStart() throws IOException {
        return this.wrappedDecoder.readArrayStart();
    }

    public long arrayNext() throws IOException {
        return this.wrappedDecoder.arrayNext();
    }

    public long skipArray() throws IOException {
        return this.wrappedDecoder.skipArray();
    }

    public long readMapStart() throws IOException {
        return this.wrappedDecoder.readMapStart();
    }

    public long mapNext() throws IOException {
        return this.wrappedDecoder.mapNext();
    }

    public long skipMap() throws IOException {
        return this.wrappedDecoder.skipMap();
    }

    public int readIndex() throws IOException {
        return this.wrappedDecoder.readIndex();
    }
}

