/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnEncoder
extends Encoder {
    private final BinaryEncoder wrappedEncoder;
    private final OutputStream out;

    public ColumnEncoder(OutputStream out) {
        this.out = out;
        this.wrappedEncoder = new EncoderFactory().binaryEncoder(out, null);
    }

    public ColumnEncoder(OutputStream out, ColumnEncoder reuse) {
        this.out = out;
        this.wrappedEncoder = new EncoderFactory().binaryEncoder(out, reuse.wrappedEncoder);
    }

    public void flush() throws IOException {
        this.wrappedEncoder.flush();
    }

    public void writeNull() throws IOException {
        this.wrappedEncoder.writeNull();
    }

    public void writeBoolean(boolean b) throws IOException {
        this.wrappedEncoder.writeBoolean(b);
    }

    public void writeInt(int n) throws IOException {
        this.out.write(Bytes.toBytes((int)n));
    }

    public void writeLong(long n) throws IOException {
        this.out.write(Bytes.toBytes((long)n));
    }

    public void writeFloat(float f) throws IOException {
        this.wrappedEncoder.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        this.wrappedEncoder.writeDouble(d);
    }

    public void writeString(Utf8 utf8) throws IOException {
        this.out.write(utf8.getBytes(), 0, utf8.getByteLength());
    }

    public void writeBytes(ByteBuffer bytes) throws IOException {
        this.wrappedEncoder.writeBytes(bytes);
    }

    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        this.wrappedEncoder.writeBytes(bytes, start, len);
    }

    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.wrappedEncoder.writeFixed(bytes, start, len);
    }

    public void writeEnum(int e) throws IOException {
        this.wrappedEncoder.writeEnum(e);
    }

    public void writeArrayStart() throws IOException {
        this.wrappedEncoder.writeArrayStart();
    }

    public void setItemCount(long itemCount) throws IOException {
        this.wrappedEncoder.setItemCount(itemCount);
    }

    public void startItem() throws IOException {
        this.wrappedEncoder.startItem();
    }

    public void writeArrayEnd() throws IOException {
        this.wrappedEncoder.writeArrayEnd();
    }

    public void writeMapStart() throws IOException {
        this.wrappedEncoder.writeMapStart();
    }

    public void writeMapEnd() throws IOException {
        this.wrappedEncoder.writeMapEnd();
    }

    public void writeIndex(int unionIndex) throws IOException {
        this.wrappedEncoder.writeIndex(unionIndex);
    }
}

