/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase;

import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Flushable;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.hbase.DaoDataset;
import org.kitesdk.data.hbase.HBaseViewKeyInputFormat;
import org.kitesdk.data.hbase.impl.EntityBatch;
import org.kitesdk.data.hbase.impl.EntityScanner;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.AbstractDatasetWriter;
import org.kitesdk.data.spi.AbstractRefinableView;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.InitializeAccessor;
import org.kitesdk.data.spi.InputFormatAccessor;
import org.kitesdk.data.spi.Marker;
import org.kitesdk.data.spi.MarkerRange;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.Iterables;

class DaoView<E>
extends AbstractRefinableView<E>
implements InputFormatAccessor<E> {
    private final DaoDataset<E> dataset;

    DaoView(DaoDataset<E> dataset, Class<E> type) {
        super(dataset, type);
        this.dataset = dataset;
    }

    private DaoView(DaoView<E> view, Constraints constraints) {
        super(view, constraints);
        this.dataset = view.dataset;
    }

    private DaoView(DaoView<?> view, Schema schema, Class<E> type) {
        super(view, schema, type);
        this.dataset = (DaoDataset)view.dataset.asType(type);
    }

    protected DaoView<E> filter(Constraints constraints) {
        return new DaoView<E>(this, constraints);
    }

    protected <T> AbstractRefinableView<T> project(Schema schema, Class<T> type) {
        return new DaoView<T>(this, schema, type);
    }

    EntityScanner<E> newEntityScanner() {
        Iterable markerRanges = this.constraints.toKeyRanges();
        MarkerRange range = (MarkerRange)Iterables.getOnlyElement(markerRanges);
        return this.dataset.getDao().getScanner(this.toPartitionKey(range.getStart()), range.getStart().isInclusive(), this.toPartitionKey(range.getEnd()), range.getEnd().isInclusive());
    }

    public DatasetReader<E> newReader() {
        final EntityScanner<E> wrappedReader = this.newEntityScanner();
        final Iterator filteredIterator = this.constraints.filter(wrappedReader.iterator(), this.getAccessor());
        AbstractDatasetReader reader = new AbstractDatasetReader<E>(){

            public void initialize() {
                if (wrappedReader instanceof InitializeAccessor) {
                    ((InitializeAccessor)wrappedReader).initialize();
                }
            }

            public boolean hasNext() {
                Preconditions.checkState(this.isOpen(), "Attempt to read from a scanner that is not open");
                return filteredIterator.hasNext();
            }

            public E next() {
                Preconditions.checkState(this.isOpen(), "Attempt to read from a scanner that is not open");
                return filteredIterator.next();
            }

            public void remove() {
                Preconditions.checkState(this.isOpen(), "Attempt to read from a scanner that is not open");
                filteredIterator.remove();
            }

            public void close() {
                wrappedReader.close();
            }

            public boolean isOpen() {
                return wrappedReader.isOpen();
            }

            public Iterator<E> iterator() {
                return filteredIterator;
            }
        };
        reader.initialize();
        return reader;
    }

    public DatasetWriter<E> newWriter() {
        final EntityBatch<E> wrappedWriter = this.dataset.getDao().newBatch();
        if (this.constraints.isUnbounded()) {
            wrappedWriter.initialize();
            return wrappedWriter;
        }
        final StorageKey partitionStratKey = new StorageKey(this.dataset.getDescriptor().getPartitionStrategy());
        AbstractFlushableDatasetWriter writer = new AbstractFlushableDatasetWriter<E>(){
            private Constraints.KeyPredicate keyPredicate;
            {
                this.keyPredicate = DaoView.this.constraints.toKeyPredicate();
            }

            public void initialize() {
                wrappedWriter.initialize();
            }

            public void write(E entity) {
                StorageKey key = DaoView.this.getAccessor().keyFor(entity, DaoView.this.constraints.getProvidedValues(), partitionStratKey);
                if (!this.keyPredicate.apply(key)) {
                    throw new IllegalArgumentException("View does not contain entity: " + entity);
                }
                wrappedWriter.write(entity);
            }

            public void flush() {
                wrappedWriter.flush();
            }

            public void close() {
                wrappedWriter.close();
            }

            public boolean isOpen() {
                return wrappedWriter.isOpen();
            }
        };
        writer.initialize();
        return writer;
    }

    PartitionKey toPartitionKey(MarkerRange.Boundary boundary) {
        if (boundary == null || boundary.getBound() == null) {
            return null;
        }
        return DaoView.keyFor(this.dataset.getDescriptor().getPartitionStrategy(), boundary.getBound());
    }

    @Deprecated
    static PartitionKey keyFor(PartitionStrategy strategy, Marker marker) {
        List partitioners = Accessor.getDefault().getFieldPartitioners(strategy);
        Object[] values = new Object[partitioners.size()];
        int n = partitioners.size();
        for (int i = 0; i < n; ++i) {
            FieldPartitioner fp = (FieldPartitioner)partitioners.get(i);
            values[i] = marker.valueFor(fp);
        }
        return new PartitionKey(values);
    }

    public InputFormat<E, Void> getInputFormat(Configuration conf) {
        return new HBaseViewKeyInputFormat(this);
    }

    static abstract class AbstractFlushableDatasetWriter<E>
    extends AbstractDatasetWriter<E>
    implements Flushable {
        AbstractFlushableDatasetWriter() {
        }
    }
}

