/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import java.io.InputStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.hbase.client.HTablePool;
import org.kitesdk.data.hbase.avro.AvroEntityComposer;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroEntitySerDe;
import org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser;
import org.kitesdk.data.hbase.avro.AvroKeySchema;
import org.kitesdk.data.hbase.avro.AvroKeySerDe;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.avro.VersionedAvroEntityMapper;
import org.kitesdk.data.hbase.impl.BaseDao;
import org.kitesdk.data.hbase.impl.BaseEntityMapper;
import org.kitesdk.data.hbase.impl.SchemaManager;

public class GenericAvroDao
extends BaseDao<GenericRecord> {
    private static final AvroKeyEntitySchemaParser parser = new AvroKeyEntitySchemaParser();

    public GenericAvroDao(HTablePool tablePool, String tableName, String entitySchemaString) {
        super(tablePool, tableName, GenericAvroDao.buildEntityMapper(entitySchemaString));
    }

    public GenericAvroDao(HTablePool tablePool, String tableName, InputStream entitySchemaStream) {
        super(tablePool, tableName, GenericAvroDao.buildEntityMapper(AvroUtils.inputStreamToString(entitySchemaStream)));
    }

    public GenericAvroDao(HTablePool tablePool, String tableName, String entityName, SchemaManager schemaManager, String entitySchemaString) {
        super(tablePool, tableName, new VersionedAvroEntityMapper.Builder().setSchemaManager(schemaManager).setTableName(tableName).setEntityName(entityName).setSpecific(false).setGenericSchemaString(entitySchemaString).build());
    }

    public GenericAvroDao(HTablePool tablePool, String tableName, String entityName, SchemaManager schemaManager) {
        super(tablePool, tableName, new VersionedAvroEntityMapper.Builder().setSchemaManager(schemaManager).setTableName(tableName).setEntityName(entityName).setSpecific(false).build());
    }

    private static BaseEntityMapper<GenericRecord> buildEntityMapper(String readerSchemaStr) {
        return GenericAvroDao.buildEntityMapper(readerSchemaStr, readerSchemaStr);
    }

    private static BaseEntityMapper<GenericRecord> buildEntityMapper(String readerSchemaStr, String writtenSchemaStr) {
        AvroEntitySchema readerSchema = parser.parseEntitySchema(readerSchemaStr);
        AvroEntitySchema writtenSchema = parser.parseEntitySchema(writtenSchemaStr);
        AvroEntityComposer entityComposer = new AvroEntityComposer(readerSchema, false);
        AvroEntitySerDe entitySerDe = new AvroEntitySerDe(entityComposer, readerSchema, writtenSchema, false);
        AvroKeySchema keySchema = parser.parseKeySchema(readerSchemaStr);
        AvroKeySerDe keySerDe = new AvroKeySerDe(keySchema.getAvroSchema(), keySchema.getPartitionStrategy());
        return new BaseEntityMapper<GenericRecord>(keySchema, readerSchema, keySerDe, entitySerDe);
    }
}

