/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import org.apache.hadoop.hbase.client.HTablePool;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.hbase.impl.Dao;
import org.kitesdk.data.hbase.impl.EntityBatch;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.EntityScanner;
import org.kitesdk.data.hbase.impl.EntityScannerBuilder;
import org.kitesdk.data.hbase.impl.EntitySchema;
import org.kitesdk.data.hbase.impl.EntitySerDe;
import org.kitesdk.data.hbase.impl.HBaseClientTemplate;
import org.kitesdk.data.hbase.impl.KeySchema;
import org.kitesdk.data.hbase.impl.KeySerDe;
import org.kitesdk.data.hbase.impl.VersionCheckAction;
import org.kitesdk.data.spi.PartitionKey;

public class BaseDao<E>
implements Dao<E> {
    private final String tableName;
    private final EntityMapper<E> entityMapper;
    private final HBaseClientTemplate clientTemplate;

    public BaseDao(HTablePool tablePool, String tableName, EntityMapper<E> entityMapper) {
        this.tableName = tableName;
        this.entityMapper = entityMapper;
        this.clientTemplate = new HBaseClientTemplate(tablePool, tableName);
    }

    public BaseDao(BaseDao<E> dao) {
        this.tableName = dao.tableName;
        this.clientTemplate = new HBaseClientTemplate(dao.clientTemplate);
        this.entityMapper = dao.entityMapper;
    }

    @Override
    public E get(PartitionKey key) {
        return this.clientTemplate.get(key, this.entityMapper);
    }

    @Override
    public boolean put(E entity) {
        return this.clientTemplate.put(entity, this.entityMapper);
    }

    @Override
    public long increment(PartitionKey key, String fieldName, long amount) {
        return this.clientTemplate.increment(key, fieldName, amount, this.entityMapper);
    }

    @Override
    public void delete(PartitionKey key) {
        this.clientTemplate.delete(key, this.entityMapper.getRequiredColumns(), null, this.entityMapper.getKeySerDe());
    }

    @Override
    public boolean delete(E entity) {
        VersionCheckAction checkAction = this.entityMapper.mapFromEntity(entity).getVersionCheckAction();
        PartitionKey key = this.entityMapper.mapToKey(entity);
        return this.clientTemplate.delete(key, this.entityMapper.getRequiredColumns(), checkAction, this.entityMapper.getKeySerDe());
    }

    @Override
    public EntityScanner<E> getScanner() {
        return this.getScanner(null, null);
    }

    @Override
    public EntityScanner<E> getScanner(PartitionKey startKey, PartitionKey stopKey) {
        return this.getScanner(startKey, true, stopKey, true);
    }

    @Override
    public EntityScanner<E> getScanner(PartitionKey startKey, boolean startInclusive, PartitionKey stopKey, boolean stopInclusive) {
        return this.clientTemplate.getScannerBuilder(this.entityMapper).setStartKey(startKey).setStartInclusive(startInclusive).setStopKey(stopKey).setStopInclusive(stopInclusive).build();
    }

    public EntityScannerBuilder<E> getScannerBuilder() {
        return this.clientTemplate.getScannerBuilder(this.entityMapper);
    }

    @Override
    public EntityBatch<E> newBatch(long writeBufferSize) {
        return this.clientTemplate.createBatch(this.entityMapper, writeBufferSize);
    }

    @Override
    public EntityBatch<E> newBatch() {
        return this.clientTemplate.createBatch(this.entityMapper);
    }

    public HBaseClientTemplate getHBaseClientTemplate() {
        return this.clientTemplate;
    }

    @Override
    public KeySchema getKeySchema() {
        return this.entityMapper.getKeySchema();
    }

    @Override
    public EntitySchema getEntitySchema() {
        return this.entityMapper.getEntitySchema();
    }

    public KeySerDe getKeySerDe() {
        return this.entityMapper.getKeySerDe();
    }

    public EntitySerDe<E> getEntitySerDe() {
        return this.entityMapper.getEntitySerDe();
    }

    public EntityMapper<E> getEntityMapper() {
        return this.entityMapper;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public PartitionStrategy getPartitionStrategy() {
        return this.entityMapper.getKeySchema().getPartitionStrategy();
    }
}

