/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.kitesdk.compat.DynMethods;
import org.kitesdk.data.hbase.impl.PutAction;
import org.kitesdk.data.hbase.impl.VersionCheckAction;

public class HBaseUtils {
    private static final DynMethods.UnboundMethod GET_FAMILY_MAP_METHOD = new DynMethods.Builder("getFamilyMap").impl(Put.class, new Class[0]).build();

    public static Put mergePuts(byte[] keyBytes, List<Put> putList) {
        Put put = new Put(keyBytes);
        for (Put putToMerge : putList) {
            Map familyMap = (Map)GET_FAMILY_MAP_METHOD.invoke((Object)putToMerge, new Object[0]);
            for (List keyValueList : familyMap.values()) {
                for (KeyValue keyValue : keyValueList) {
                    put.add(keyValue.getFamily(), keyValue.getQualifier(), keyValue.getTimestamp(), keyValue.getValue());
                }
            }
        }
        return put;
    }

    public static PutAction mergePutActions(byte[] keyBytes, List<PutAction> putActionList) {
        VersionCheckAction checkAction = null;
        ArrayList<Put> putsToMerge = new ArrayList<Put>();
        for (PutAction putActionToMerge : putActionList) {
            putsToMerge.add(putActionToMerge.getPut());
            VersionCheckAction checkActionToMerge = putActionToMerge.getVersionCheckAction();
            if (checkActionToMerge == null) continue;
            checkAction = checkActionToMerge;
        }
        Put put = HBaseUtils.mergePuts(keyBytes, putsToMerge);
        return new PutAction(put, checkAction);
    }

    private static void addColumnsToOperation(Collection<String> columns, Operation operation) {
        HashSet<String> familySet = new HashSet<String>();
        for (String column : columns) {
            String[] familyAndColumn = column.split(":");
            if (familyAndColumn.length == 1) {
                familySet.add(familyAndColumn[0]);
                operation.addFamily(Bytes.toBytes((String)familyAndColumn[0]));
                continue;
            }
            if (familySet.contains(familyAndColumn[0])) continue;
            operation.addColumn(Bytes.toBytes((String)familyAndColumn[0]), Bytes.toBytes((String)familyAndColumn[1]));
        }
    }

    public static void addColumnsToScan(Collection<String> columns, final Scan scan) {
        HBaseUtils.addColumnsToOperation(columns, new Operation(){

            @Override
            public void addColumn(byte[] family, byte[] column) {
                scan.addColumn(family, column);
            }

            @Override
            public void addFamily(byte[] family) {
                scan.addFamily(family);
            }
        });
    }

    public static void addColumnsToGet(Collection<String> columns, final Get get) {
        HBaseUtils.addColumnsToOperation(columns, new Operation(){

            @Override
            public void addColumn(byte[] family, byte[] column) {
                get.addColumn(family, column);
            }

            @Override
            public void addFamily(byte[] family) {
                get.addFamily(family);
            }
        });
    }

    private static interface Operation {
        public void addColumn(byte[] var1, byte[] var2);

        public void addFamily(byte[] var1);
    }
}

