/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;
import org.kitesdk.compat.DynConstructors;
import org.kitesdk.compat.DynMethods;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.ImmutableList;
import org.kitesdk.shaded.com.google.common.collect.ImmutableMap;
import org.kitesdk.shaded.com.google.common.collect.Lists;

public class HiveSchemaConverter {
    private static final DynMethods.StaticMethod primitiveTypeForName = new DynMethods.Builder("getPrimitiveTypeInfo").impl(TypeInfoFactory.class, new Class[]{String.class}).buildStatic();
    private static final DynMethods.StaticMethod parseTypeInfo = new DynMethods.Builder("getTypeInfoFromTypeString").impl(TypeInfoUtils.class, new Class[]{String.class}).buildStatic();
    @VisibleForTesting
    static final Class<?> charClass = HiveSchemaConverter.findTypeInfoClass("org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo");
    @VisibleForTesting
    static final Class<?> varcharClass = HiveSchemaConverter.findTypeInfoClass("org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo");
    @VisibleForTesting
    static final Class<?> decimalClass = HiveSchemaConverter.findTypeInfoClass("org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo");
    private static final ImmutableMap<String, Schema.Type> TYPEINFO_TO_TYPE = ImmutableMap.builder().put("boolean", Schema.Type.BOOLEAN).put("tinyint", Schema.Type.INT).put("smallint", Schema.Type.INT).put("int", Schema.Type.INT).put("bigint", Schema.Type.LONG).put("float", Schema.Type.FLOAT).put("double", Schema.Type.DOUBLE).put("string", Schema.Type.STRING).put("binary", Schema.Type.BYTES).put("void", Schema.Type.NULL).build();
    static final ImmutableMap<Schema.Type, TypeInfo> TYPE_TO_TYPEINFO = ImmutableMap.builder().put(Schema.Type.BOOLEAN, HiveSchemaConverter.primitiveTypeInfo("boolean")).put(Schema.Type.INT, HiveSchemaConverter.primitiveTypeInfo("int")).put(Schema.Type.LONG, HiveSchemaConverter.primitiveTypeInfo("bigint")).put(Schema.Type.FLOAT, HiveSchemaConverter.primitiveTypeInfo("float")).put(Schema.Type.DOUBLE, HiveSchemaConverter.primitiveTypeInfo("double")).put(Schema.Type.STRING, HiveSchemaConverter.primitiveTypeInfo("string")).put(Schema.Type.ENUM, HiveSchemaConverter.primitiveTypeInfo("string")).put(Schema.Type.BYTES, HiveSchemaConverter.primitiveTypeInfo("binary")).put(Schema.Type.FIXED, HiveSchemaConverter.primitiveTypeInfo("binary")).build();
    private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
    @VisibleForTesting
    static final NullNode NULL_DEFAULT = NullNode.getInstance();
    @VisibleForTesting
    static final Collection<String[]> NO_REQUIRED_FIELDS = ImmutableList.of();

    private static Class<?> findTypeInfoClass(String className) {
        try {
            return new DynConstructors.Builder(TypeInfo.class).impl(className, new Class[0]).buildChecked().getConstructedClass();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static TypeInfo primitiveTypeInfo(String type) {
        return (TypeInfo)primitiveTypeForName.invoke(new Object[]{type});
    }

    public static TypeInfo parseTypeInfo(String type) {
        return (TypeInfo)parseTypeInfo.invoke(new Object[]{type});
    }

    public static Schema convertTable(String table, Collection<FieldSchema> columns, @Nullable PartitionStrategy strategy) {
        ArrayList<String> fieldNames = Lists.newArrayList();
        ArrayList<TypeInfo> fieldTypes = Lists.newArrayList();
        LinkedList<String> start = Lists.newLinkedList();
        Collection<String[]> requiredFields = HiveSchemaConverter.requiredFields(strategy);
        ArrayList<Schema.Field> fields = Lists.newArrayList();
        for (FieldSchema column : columns) {
            TypeInfo type = HiveSchemaConverter.parseTypeInfo(column.getType());
            fieldNames.add(column.getName());
            fieldTypes.add(type);
            fields.add(HiveSchemaConverter.convertField(start, column.getName(), type, requiredFields));
        }
        StructTypeInfo struct = new StructTypeInfo();
        struct.setAllStructFieldNames(fieldNames);
        struct.setAllStructFieldTypeInfos(fieldTypes);
        Schema recordSchema = Schema.createRecord((String)table, (String)HiveSchemaConverter.doc((TypeInfo)struct), null, (boolean)false);
        recordSchema.setFields(fields);
        return recordSchema;
    }

    private static Schema convert(LinkedList<String> path, String name, StructTypeInfo type, Collection<String[]> required) {
        ArrayList names = type.getAllStructFieldNames();
        ArrayList types = type.getAllStructFieldTypeInfos();
        Preconditions.checkArgument(names.size() == types.size(), "Cannot convert struct: %s names != %s types", names.size(), types.size());
        ArrayList<Schema.Field> fields = Lists.newArrayList();
        for (int i = 0; i < names.size(); ++i) {
            path.addLast(name);
            fields.add(HiveSchemaConverter.convertField(path, (String)names.get(i), (TypeInfo)types.get(i), required));
            path.removeLast();
        }
        Schema recordSchema = Schema.createRecord((String)name, (String)HiveSchemaConverter.doc((TypeInfo)type), null, (boolean)false);
        recordSchema.setFields(fields);
        return recordSchema;
    }

    private static Schema.Field convertField(LinkedList<String> path, String name, TypeInfo type, Collection<String[]> required) {
        boolean isOptional;
        Collection<String[]> matchingRequired = HiveSchemaConverter.filterByStartsWith(required, path, name);
        Schema schema = HiveSchemaConverter.convert(path, name, type, matchingRequired);
        boolean bl = isOptional = schema.getType() == Schema.Type.UNION;
        if (!isOptional && matchingRequired.size() < 1) {
            schema = HiveSchemaConverter.optional(schema);
            isOptional = true;
        }
        return new Schema.Field(name, schema, HiveSchemaConverter.doc(type), (JsonNode)(isOptional ? NULL_DEFAULT : null));
    }

    @VisibleForTesting
    static Schema convert(LinkedList<String> path, String name, TypeInfo type, Collection<String[]> required) {
        switch (type.getCategory()) {
            case PRIMITIVE: {
                if (type.getClass() == charClass || type.getClass() == varcharClass) {
                    return Schema.create((Schema.Type)Schema.Type.STRING);
                }
                String typeInfoName = type.getTypeName();
                Preconditions.checkArgument(TYPEINFO_TO_TYPE.containsKey(typeInfoName), "Cannot convert unsupported type: %s", typeInfoName);
                return Schema.create((Schema.Type)TYPEINFO_TO_TYPE.get(typeInfoName));
            }
            case LIST: {
                return Schema.createArray((Schema)HiveSchemaConverter.optional(HiveSchemaConverter.convert(path, name, ((ListTypeInfo)type).getListElementTypeInfo(), required)));
            }
            case MAP: {
                MapTypeInfo mapType = (MapTypeInfo)type;
                Preconditions.checkArgument("string".equals(mapType.getMapKeyTypeInfo().toString()), "Non-String map key type: %s", mapType.getMapKeyTypeInfo());
                return Schema.createMap((Schema)HiveSchemaConverter.optional(HiveSchemaConverter.convert(path, name, mapType.getMapValueTypeInfo(), required)));
            }
            case STRUCT: {
                return HiveSchemaConverter.convert(path, name, (StructTypeInfo)type, required);
            }
            case UNION: {
                List unionTypes = ((UnionTypeInfo)type).getAllUnionObjectTypeInfos();
                ArrayList<Schema> types = Lists.newArrayList(NULL);
                for (int i = 0; i < unionTypes.size(); ++i) {
                    types.add(HiveSchemaConverter.convert(path, name + "_" + i, (TypeInfo)unionTypes.get(i), NO_REQUIRED_FIELDS));
                }
                return Schema.createUnion(types);
            }
        }
        throw new IllegalArgumentException("Unknown TypeInfo category: " + type.getCategory());
    }

    @VisibleForTesting
    static Schema optional(Schema schema) {
        return Schema.createUnion(Lists.newArrayList(NULL, schema));
    }

    private static String doc(TypeInfo type) {
        if (type instanceof StructTypeInfo) {
            return null;
        }
        return "Converted from '" + String.valueOf(type) + "'";
    }

    public static List<FieldSchema> convertSchema(Schema avroSchema) {
        ArrayList<FieldSchema> columns = Lists.newArrayList();
        if (Schema.Type.RECORD.equals((Object)avroSchema.getType())) {
            for (Schema.Field field : avroSchema.getFields()) {
                columns.add(new FieldSchema(field.name(), HiveSchemaConverter.convert(field.schema()).getTypeName(), field.doc()));
            }
        } else {
            columns.add(new FieldSchema("column", HiveSchemaConverter.convert(avroSchema).getTypeName(), avroSchema.getDoc()));
        }
        return columns;
    }

    @VisibleForTesting
    static TypeInfo convert(Schema schema) {
        return (TypeInfo)SchemaUtil.visit((Schema)schema, (SchemaUtil.SchemaVisitor)new Converter());
    }

    private static Collection<String[]> filterByStartsWith(Collection<String[]> fields, LinkedList<String> path, String name) {
        path.addLast(name);
        ArrayList<String[]> startsWithCollection = Lists.newArrayList();
        for (String[] field : fields) {
            if (!HiveSchemaConverter.startsWith(field, path)) continue;
            startsWithCollection.add(field);
        }
        path.removeLast();
        return startsWithCollection;
    }

    private static boolean startsWith(String[] left, List<String> right) {
        if (left.length < right.size()) {
            return false;
        }
        for (int i = 0; i < right.size(); ++i) {
            if (left[i].equals(right.get(i))) continue;
            return false;
        }
        return true;
    }

    private static Collection<String[]> requiredFields(@Nullable PartitionStrategy strategy) {
        if (strategy == null) {
            return NO_REQUIRED_FIELDS;
        }
        ArrayList<String[]> requiredFields = Lists.newArrayList();
        for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(strategy)) {
            if (fp.getSourceName() == null) continue;
            requiredFields.add(fp.getSourceName().split("\\."));
        }
        return requiredFields;
    }

    private static class Converter
    extends SchemaUtil.SchemaVisitor<TypeInfo> {
        private Converter() {
        }

        public TypeInfo record(Schema record, List<String> names, List<TypeInfo> types) {
            return TypeInfoFactory.getStructTypeInfo(names, types);
        }

        public TypeInfo union(Schema union, List<TypeInfo> options) {
            ArrayList<TypeInfo> nonNullTypes = Lists.newArrayList();
            for (TypeInfo type : options) {
                if (type == null) continue;
                nonNullTypes.add(type);
            }
            if (nonNullTypes.size() == 1) {
                return (TypeInfo)nonNullTypes.get(0);
            }
            return TypeInfoFactory.getUnionTypeInfo(nonNullTypes);
        }

        public TypeInfo array(Schema array, TypeInfo element) {
            return TypeInfoFactory.getListTypeInfo((TypeInfo)element);
        }

        public TypeInfo map(Schema map, TypeInfo value) {
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)TYPE_TO_TYPEINFO.get(Schema.Type.STRING), (TypeInfo)value);
        }

        public TypeInfo primitive(Schema primitive) {
            return TYPE_TO_TYPEINFO.get(primitive.getType());
        }
    }
}

