/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.metrics.servlets;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.typesafe.config.Config;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.base.AbstractCommand;

public final class RegisterJVMMetricsBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("registerJVMMetrics");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new RegisterJVMMetrics(this, config, parent, child, context);
    }

    private static final class RegisterJVMMetrics
    extends AbstractCommand {
        public RegisterJVMMetrics(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.validateArguments();
            MetricRegistry registry = context.getMetricRegistry();
            BufferPoolMetricSet bufferPoolMetrics = new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer());
            this.registerAll("jvm.buffers", (MetricSet)bufferPoolMetrics, registry);
            this.registerAll("jvm.gc", (MetricSet)new GarbageCollectorMetricSet(), registry);
            this.registerAll("jvm.memory", (MetricSet)new MemoryUsageGaugeSet(), registry);
            this.registerAll("jvm.threads", (MetricSet)new ThreadStatesGaugeSet(), registry);
            this.register("jvm.fileDescriptorCountRatio", (Metric)new FileDescriptorRatioGauge(), registry);
            context.getHealthCheckRegistry().register("deadlocks", (HealthCheck)new ThreadDeadlockHealthCheck());
        }

        private void registerAll(String prefix, MetricSet metrics, MetricRegistry registry) {
            for (Map.Entry entry : metrics.getMetrics().entrySet()) {
                String name = MetricRegistry.name((String)prefix, (String[])new String[]{(String)entry.getKey()});
                if (entry.getValue() instanceof MetricSet) {
                    this.registerAll(name, (MetricSet)entry.getValue(), registry);
                    continue;
                }
                this.register(name, (Metric)entry.getValue(), registry);
            }
        }

        private void register(String name, Metric metric, MetricRegistry registry) {
            block3: {
                if (!registry.getMetrics().containsKey(name)) {
                    try {
                        registry.register(name, metric);
                    }
                    catch (IllegalArgumentException e) {
                        String msg = "A metric named " + name + " already exists";
                        if (msg.equals(e.getMessage())) break block3;
                        throw e;
                    }
                }
            }
        }
    }
}

