/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.metrics.servlets;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.servlets.AdminServlet;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Notifications;

public final class StartReportingMetricsToHTTPBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("startReportingMetricsToHTTP");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new StartReportingMetricsToHTTP(this, config, parent, child, context);
    }

    private static final class StartReportingMetricsToHTTP
    extends AbstractCommand {
        private final int port;
        private static final Map<Integer, Server> SERVERS = new HashMap<Integer, Server>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StartReportingMetricsToHTTP(CommandBuilder builder, Config config, Command parent, Command child, final MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.port = this.getConfigs().getInt(config, "port", 8080);
            final TimeUnit defaultDurationUnit = this.getConfigs().getTimeUnit(config, "defaultDurationUnit", TimeUnit.MILLISECONDS);
            final TimeUnit defaultRateUnit = this.getConfigs().getTimeUnit(config, "defaultRateUnit", TimeUnit.SECONDS);
            this.validateArguments();
            Map<Integer, Server> map = SERVERS;
            synchronized (map) {
                Server server = SERVERS.get(this.port);
                if (server == null) {
                    ServletContextHandler servletContextHandler = new ServletContextHandler();
                    servletContextHandler.addServlet(AdminServlet.class, "/*");
                    servletContextHandler.addEventListener((EventListener)new MetricsServlet.ContextListener(){

                        protected MetricRegistry getMetricRegistry() {
                            return context.getMetricRegistry();
                        }

                        protected TimeUnit getRateUnit() {
                            return defaultRateUnit;
                        }

                        protected TimeUnit getDurationUnit() {
                            return defaultDurationUnit;
                        }
                    });
                    servletContextHandler.addEventListener((EventListener)new HealthCheckServlet.ContextListener(){

                        protected HealthCheckRegistry getHealthCheckRegistry() {
                            return context.getHealthCheckRegistry();
                        }
                    });
                    server = new Server(this.port);
                    server.setHandler((Handler)servletContextHandler);
                    try {
                        server.start();
                    }
                    catch (Exception e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    SERVERS.put(this.port, server);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doNotify(Record notification) {
            for (Object event : Notifications.getLifecycleEvents((Record)notification)) {
                if (event != Notifications.LifecycleEvent.SHUTDOWN) continue;
                Map<Integer, Server> map = SERVERS;
                synchronized (map) {
                    Server server = SERVERS.remove(this.port);
                    if (server != null) {
                        try {
                            server.stop();
                            server.join();
                        }
                        catch (Exception e) {
                            throw new MorphlineRuntimeException((Throwable)e);
                        }
                    }
                }
            }
            super.doNotify(notification);
        }
    }
}

