/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.useragent;

import com.codahale.metrics.Meter;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.Validator;
import org.kitesdk.morphline.shaded.com.google.common.io.Closeables;
import ua_parser.Client;
import ua_parser.Parser;

public final class UserAgentBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("userAgent");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new UserAgent(this, config, parent, child, context);
    }

    private static final class BoundedLRUHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        private BoundedLRUHashMap(int capacity) {
            super(16, 0.5f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.capacity;
        }
    }

    private static enum Component {
        ua_family,
        ua_major,
        ua_minor,
        ua_patch,
        os_family,
        os_major,
        os_minor,
        os_patch,
        os_patch_minor,
        device_family;

    }

    private static final class Mapping {
        private final String fieldName;
        private final List components = new ArrayList();
        private final Parser parser;
        private final Map<String, String> cache;
        private final String nullReplacement;
        private final Meter numCacheHitsMeter;
        private final Meter numCacheMissesMeter;
        private static final String START_TOKEN = "@{";
        private static final char END_TOKEN = '}';

        public Mapping(String fieldName, String expression, Parser parser, Map<String, String> cache, String nullReplacement, Config config, Meter numCacheHitsMeter, Meter numCacheMissesMeter) {
            this.fieldName = fieldName;
            this.parser = parser;
            this.cache = cache;
            Preconditions.checkNotNull((Object)nullReplacement);
            this.nullReplacement = nullReplacement;
            this.numCacheHitsMeter = numCacheHitsMeter;
            this.numCacheMissesMeter = numCacheMissesMeter;
            int from = 0;
            while (from < expression.length()) {
                int end;
                int start = expression.indexOf(START_TOKEN, from);
                if (start < 0) {
                    this.components.add(expression.substring(from, expression.length()));
                    return;
                }
                if (start > from) {
                    this.components.add(expression.substring(from, start));
                }
                if ((end = expression.indexOf(125, start + START_TOKEN.length())) < 0) {
                    throw new IllegalArgumentException("Missing closing token: }");
                }
                String ref = expression.substring(start + START_TOKEN.length(), end);
                this.components.add(new Validator().validateEnum(config, ref, Component.class, (Enum[])new Component[0]));
                from = end + 1;
            }
        }

        public void apply(Record record, String userAgent) {
            String result = this.cache.get(userAgent);
            if (result == null) {
                if (this.numCacheMissesMeter != null) {
                    this.numCacheMissesMeter.mark();
                }
                result = this.extract(userAgent);
                this.cache.put(userAgent, result);
            } else if (this.numCacheHitsMeter != null) {
                this.numCacheHitsMeter.mark();
            }
            record.put(this.fieldName, (Object)result);
        }

        private String extract(String userAgent) {
            Client client = this.parser.parse(userAgent);
            StringBuilder buf = new StringBuilder();
            String lastString = null;
            for (Object component : this.components) {
                assert (component != null);
                if (component instanceof Component) {
                    String result = this.resolve((Component)((Object)component), client);
                    if (result == null) {
                        result = this.nullReplacement;
                    }
                    if (result.length() > 0 && lastString != null) {
                        buf.append(lastString);
                    }
                    buf.append(result);
                    lastString = null;
                    continue;
                }
                lastString = (String)component;
            }
            if (lastString != null) {
                buf.append(lastString);
            }
            return buf.toString();
        }

        private String resolve(Component component, Client client) {
            switch (component) {
                case ua_family: {
                    return client.userAgent.family;
                }
                case ua_major: {
                    return client.userAgent.major;
                }
                case ua_minor: {
                    return client.userAgent.minor;
                }
                case ua_patch: {
                    return client.userAgent.patch;
                }
                case os_family: {
                    return client.os.family;
                }
                case os_major: {
                    return client.os.major;
                }
                case os_minor: {
                    return client.os.minor;
                }
                case os_patch: {
                    return client.os.patch;
                }
                case os_patch_minor: {
                    return client.os.patchMinor;
                }
                case device_family: {
                    return client.device.family;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static final class UserAgent
    extends AbstractCommand {
        private final String inputFieldName;
        private final List<Mapping> mappings;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UserAgent(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            Parser parser;
            String nullReplacement;
            int cacheCapacity;
            block7: {
                super(builder, config, parent, child, context);
                this.mappings = new ArrayList<Mapping>();
                this.inputFieldName = this.getConfigs().getString(config, "inputField");
                String databaseFile = this.getConfigs().getString(config, "database", null);
                cacheCapacity = this.getConfigs().getInt(config, "cacheCapacity", 1000);
                nullReplacement = this.getConfigs().getString(config, "nullReplacement", "");
                try {
                    if (databaseFile == null) {
                        parser = new Parser();
                        break block7;
                    }
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(databaseFile));
                    try {
                        parser = new Parser((InputStream)in);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)in);
                    }
                }
                catch (IOException e) {
                    throw new MorphlineCompilationException("Cannot parse UserAgent database: " + databaseFile, config, (Throwable)e);
                }
            }
            Meter numCacheHitsMeter = this.isMeasuringMetrics() ? this.getMeter(new String[]{"numCacheHits"}) : null;
            Meter numCacheMissesMeter = this.isMeasuringMetrics() ? this.getMeter(new String[]{"numCacheMisses"}) : null;
            Config outputFields = this.getConfigs().getConfig(config, "outputFields", ConfigFactory.empty());
            for (Map.Entry entry : new Configs().getEntrySet(outputFields)) {
                this.mappings.add(new Mapping((String)entry.getKey(), entry.getValue().toString().trim(), parser, new BoundedLRUHashMap<String, String>(cacheCapacity), nullReplacement, config, numCacheHitsMeter, numCacheMissesMeter));
            }
            this.validateArguments();
        }

        protected boolean doProcess(Record record) {
            for (Object value : record.get(this.inputFieldName)) {
                Preconditions.checkNotNull(value);
                String stringValue = value.toString().trim();
                for (Mapping mapping : this.mappings) {
                    mapping.apply(record, stringValue);
                }
            }
            return super.doProcess(record);
        }
    }
}

