/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class OperCommand
extends Command<OperCommand> {
    private String user;
    private String password;

    public OperCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull OperCommand user(@NonNull String user) {
        this.user = Sanity.safeMessageCheck(user, "user");
        return this;
    }

    public @NonNull OperCommand password(@NonNull String password) {
        this.password = Sanity.safeMessageCheck(password, "password");
        return this;
    }

    @Override
    public void execute() {
        if (this.user == null) {
            throw new IllegalStateException("User not defined");
        }
        if (this.password == null) {
            throw new IllegalStateException("Password not defined");
        }
        this.sendCommandLine("OPER " + this.user + ' ' + this.password);
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("user", this.user == null ? null : "AzureDiamond").add("password", this.password == null ? null : "hunter2");
    }
}

