/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class WallopsCommand
extends Command<WallopsCommand> {
    private String message;

    public WallopsCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull WallopsCommand message(@NonNull String message) {
        this.message = Sanity.safeMessageCheck(message, "message");
        return this;
    }

    @Override
    public void execute() {
        if (this.message == null) {
            throw new IllegalStateException("Message not defined");
        }
        this.sendCommandLine("WALLOPS :" + this.message);
    }

    @Override
    public String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("message", this.message).toString();
    }
}

