/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class WhoisCommand
extends Command<WhoisCommand> {
    private @Nullable String server;
    private @Nullable String target;

    public WhoisCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull WhoisCommand server(@Nullable String server) {
        this.server = server == null ? null : Sanity.safeMessageCheck(server, "server");
        return this;
    }

    public @NonNull WhoisCommand target(@NonNull String target) {
        this.target = Sanity.safeMessageCheck(target, "target");
        return this;
    }

    @Override
    public void execute() {
        if (this.target == null) {
            throw new IllegalStateException("Target not defined");
        }
        StringBuilder builder = new StringBuilder(5 + this.target.length() + (this.server == null ? 1 : 2 + this.server.length()));
        builder.append("WHOIS ");
        if (this.server != null) {
            builder.append(this.server).append(' ');
        }
        builder.append(this.target);
        this.sendCommandLine(builder.toString());
    }

    @Override
    public String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("server", this.server).add("target", this.target).toString();
    }
}

