/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element.mode;

import java.time.Instant;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.kitteh.irc.client.library.element.mode.ModeInfo;
import org.kitteh.irc.client.library.util.Mask;
import org.kitteh.irc.client.library.util.ToStringer;

public class DefaultModeInfo
implements ModeInfo {
    private final Client client;
    private final Instant creationTime;
    private final String creator;
    private final Channel channel;
    private final Mask mask;
    private final ChannelMode mode;

    public DefaultModeInfo(@NonNull Client client, @NonNull Channel channel, @NonNull ChannelMode mode, @NonNull String mask, @Nullable String creator, @Nullable Instant creationTime) {
        this.client = client;
        this.creator = creator;
        this.channel = channel;
        this.mask = Mask.fromString(mask);
        this.creationTime = creationTime;
        this.mode = mode;
    }

    @Override
    public @NonNull Optional<String> getCreator() {
        return Optional.ofNullable(this.creator);
    }

    @Override
    public @NonNull Channel getChannel() {
        return this.channel;
    }

    @Override
    public @NonNull Client getClient() {
        return this.client;
    }

    @Override
    public @NonNull Mask getMask() {
        return this.mask;
    }

    @Override
    public @NonNull ChannelMode getMode() {
        return this.mode;
    }

    @Override
    public @NonNull Optional<Instant> getCreationTime() {
        return Optional.ofNullable(this.creationTime);
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.client).add("channel", this.channel).add("mode", this.mode).add("mask", this.mask).add("creator", this.creator).add("creationTime", this.creationTime).toString();
    }
}

