/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.feature;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.bus.error.MessageBusException;
import net.engio.mbassy.dispatch.DelegatingMessageDispatcher;
import net.engio.mbassy.dispatch.IHandlerInvocation;
import net.engio.mbassy.dispatch.IMessageDispatcher;
import net.engio.mbassy.subscription.SubscriptionContext;
import net.engio.mbassy.subscription.SubscriptionFactory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.feature.filter.FilterProcessor;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class FilteringSubscriptionFactory
extends SubscriptionFactory {
    private final Map<Class<? extends Annotation>, FilterProcessor<?, ? extends Annotation>> filters;

    public FilteringSubscriptionFactory(@NonNull Map<Class<? extends Annotation>, FilterProcessor<?, ? extends Annotation>> filters) {
        this.filters = Sanity.nullCheck(filters, "filters");
    }

    protected IMessageDispatcher buildDispatcher(SubscriptionContext context, IHandlerInvocation invocation) throws MessageBusException {
        Object dispatcher = super.buildDispatcher(context, invocation);
        ArrayList<FilterProcessorWrapper> filterWrappers = new ArrayList<FilterProcessorWrapper>();
        for (Map.Entry<Class<Annotation>, FilterProcessor<?, Annotation>> entry : this.filters.entrySet()) {
            Annotation[] annotations = context.getHandler().getMethod().getAnnotationsByType(entry.getKey());
            if (annotations.length <= 0) continue;
            filterWrappers.add(new FilterProcessorWrapper(entry.getValue(), annotations));
        }
        if (!filterWrappers.isEmpty()) {
            dispatcher = new FilteredMessageDispatcher((IMessageDispatcher)dispatcher, filterWrappers.toArray(new FilterProcessorWrapper[0]));
        }
        return dispatcher;
    }

    public @NonNull String toString() {
        return new ToStringer((Object)this).toString();
    }

    private static final class FilterProcessorWrapper {
        private final Annotation[] annotations;
        private final FilterProcessor filterProcessor;

        private FilterProcessorWrapper(FilterProcessor filterProcessor, Annotation[] annotations) {
            this.annotations = annotations;
            this.filterProcessor = filterProcessor;
        }
    }

    private final class FilteredMessageDispatcher
    extends DelegatingMessageDispatcher {
        private final FilterProcessorWrapper[] filters;

        private FilteredMessageDispatcher(IMessageDispatcher dispatcher, FilterProcessorWrapper[] filters) {
            super(dispatcher);
            this.filters = filters;
        }

        public void dispatch(MessagePublication publication, Object message, Iterable listeners) {
            for (FilterProcessorWrapper filter : this.filters) {
                if (filter.filterProcessor.accepts(message, filter.annotations)) continue;
                return;
            }
            this.getDelegate().dispatch(publication, message, listeners);
        }
    }
}

