/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.util.Optional;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.event.channel.ChannelKnockEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.kitteh.irc.client.library.feature.filter.NumericFilter;

public class DefaultKnockListener
extends AbstractDefaultListenerBase {
    public DefaultKnockListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter(value=710)
    @Handler(priority=0x7FFFFFFE)
    public void knock(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 3) {
            this.trackException(event, "KNOCK message too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getChannel(event.getParameters().get(1));
        if (!channel.isPresent()) {
            this.trackException(event, "KNOCK message sent for invalid channel name");
            return;
        }
        User user = (User)this.getTracker().getActor(event.getParameters().get(2));
        this.fire(new ChannelKnockEvent((Client)this.getClient(), event.getSource(), channel.get(), user));
    }
}

