/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.time.Instant;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultModeInfo;
import org.kitteh.irc.client.library.defaults.element.mode.DefaultModeStatusList;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.kitteh.irc.client.library.element.mode.ModeStatus;
import org.kitteh.irc.client.library.element.mode.ModeStatusList;
import org.kitteh.irc.client.library.element.mode.UserMode;
import org.kitteh.irc.client.library.event.channel.ChannelModeEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.kitteh.irc.client.library.event.user.UserModeEvent;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.kitteh.irc.client.library.feature.filter.NumericFilter;
import org.kitteh.irc.client.library.util.StringUtil;

public class DefaultModeListener
extends AbstractDefaultListenerBase {
    public DefaultModeListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter(value=324)
    @Handler(priority=0x7FFFFFFE)
    public void channelMode(ClientReceiveNumericEvent event) {
        DefaultModeStatusList<ChannelMode> statusList;
        if (event.getParameters().size() < 3) {
            this.trackException(event, "Channel mode info message too short");
            return;
        }
        Channel channel = this.getTracker().getChannel(event.getParameters().get(1)).orElse(null);
        if (channel == null) {
            this.trackException(event, "Channel mode info message sent for invalid channel name");
            return;
        }
        try {
            statusList = DefaultModeStatusList.fromChannel(this.getClient(), StringUtil.combineSplit(event.getParameters().toArray(new String[0]), 2));
        }
        catch (IllegalArgumentException e) {
            this.trackException(event, e.getMessage());
            return;
        }
        this.getTracker().updateChannelModes(channel.getName(), statusList);
    }

    @CommandFilter(value="MODE")
    @Handler(priority=0x7FFFFFFE)
    public void mode(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MODE message too short");
            return;
        }
        AbstractDefaultListenerBase.MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.Private) {
            DefaultModeStatusList<UserMode> statusList;
            try {
                statusList = DefaultModeStatusList.fromUser(this.getClient(), StringUtil.combineSplit(event.getParameters().toArray(new String[0]), 1));
            }
            catch (IllegalArgumentException e) {
                this.trackException(event, e.getMessage());
                return;
            }
            this.fire(new UserModeEvent(this.getClient(), event.getSource(), (Actor)event.getActor(), event.getParameters().get(0), (ModeStatusList<UserMode>)statusList));
            this.getClient().updateUserModes(statusList);
        } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo) {
            DefaultModeStatusList<ChannelMode> statusList;
            Channel channel = ((AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo)messageTargetInfo).getChannel();
            try {
                statusList = DefaultModeStatusList.fromChannel(this.getClient(), StringUtil.combineSplit(event.getParameters().toArray(new String[0]), 1));
            }
            catch (IllegalArgumentException e) {
                this.trackException(event, e.getMessage());
                return;
            }
            this.fire(new ChannelModeEvent(this.getClient(), event.getSource(), (Actor)event.getActor(), channel, (ModeStatusList<ChannelMode>)statusList));
            statusList.getAll().stream().filter(status -> ((ChannelMode)status.getMode()).getType() == ChannelMode.Type.A_MASK).forEach(status -> this.getTracker().trackChannelModeInfo(channel.getName(), status.getAction() == ModeStatus.Action.ADD, new DefaultModeInfo(this.getClient(), channel, (ChannelMode)status.getMode(), status.getParameter().get(), event.getActor().getName(), Instant.now())));
            this.getTracker().updateChannelModes(channel.getName(), statusList);
        } else {
            this.trackException(event, "MODE message sent for invalid target");
        }
    }
}

