/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.MonitoredNickEventBase;
import org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.kitteh.irc.client.library.event.user.MonitoredNickListEvent;
import org.kitteh.irc.client.library.event.user.MonitoredNickListFullEvent;
import org.kitteh.irc.client.library.event.user.MonitoredNickOfflineEvent;
import org.kitteh.irc.client.library.event.user.MonitoredNickOnlineEvent;
import org.kitteh.irc.client.library.feature.filter.NumericFilter;

public class DefaultMonitorListener
extends AbstractDefaultListenerBase {
    private final List<String> monitorList = new ArrayList<String>();
    private final List<ServerMessage> monitorListMessages = new ArrayList<ServerMessage>();

    public DefaultMonitorListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=730), @NumericFilter(value=731)})
    @Handler(priority=0x7FFFFFFE)
    public void monitorOnline(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MONITOR status message too short");
            return;
        }
        ServerMessage sourceMessage = event.getSource();
        for (String nick : event.getParameters().get(1).split(",")) {
            MonitoredNickEventBase monitorEvent = event.getNumeric() == 730 ? new MonitoredNickOnlineEvent(this.getClient(), sourceMessage, nick) : new MonitoredNickOfflineEvent(this.getClient(), sourceMessage, nick);
            this.fire(monitorEvent);
        }
    }

    @NumericFilter(value=732)
    @Handler(priority=0x7FFFFFFE)
    public void monitorList(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MONITOR list message too short");
            return;
        }
        Collections.addAll(this.monitorList, event.getParameters().get(1).split(","));
        this.monitorListMessages.add(event.getServerMessage());
    }

    @NumericFilter(value=733)
    @Handler(priority=0x7FFFFFFE)
    public void monitorListEnd(ClientReceiveNumericEvent event) {
        this.fire(new MonitoredNickListEvent(this.getClient(), this.monitorListMessages, this.monitorList));
        this.monitorList.clear();
        this.monitorListMessages.clear();
    }

    @NumericFilter(value=734)
    @Handler(priority=0x7FFFFFFE)
    public void monitorListFull(ClientReceiveNumericEvent event) {
        int limit;
        if (event.getParameters().size() < 3) {
            this.trackException(event, "MONITOR list full message too short");
            return;
        }
        try {
            limit = Integer.parseInt(event.getParameters().get(1));
        }
        catch (NumberFormatException e) {
            this.trackException(event, "MONITOR list full message using non-int limit");
            return;
        }
        this.fire(new MonitoredNickListFullEvent(this.getClient(), event.getSource(), limit, Arrays.stream(event.getParameters().get(2).split(",")).collect(Collectors.toList())));
    }
}

