/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.util.ArrayList;
import java.util.List;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.client.ClientReceiveMotdEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.kitteh.irc.client.library.feature.filter.NumericFilter;

public class DefaultMotdListener
extends AbstractDefaultListenerBase {
    private final List<String> motd = new ArrayList<String>();
    private final List<ServerMessage> motdMessages = new ArrayList<ServerMessage>();

    public DefaultMotdListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter(value=375)
    @Handler(priority=0x7FFFFFFE)
    public void motdStart(ClientReceiveNumericEvent event) {
        this.motd.clear();
        this.motdMessages.clear();
    }

    @NumericFilter(value=372)
    @Handler(priority=0x7FFFFFFE)
    public void motdContent(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "MOTD message too short");
            return;
        }
        this.motd.add(event.getParameters().get(1));
        this.motdMessages.add(event.getServerMessage());
    }

    @NumericFilter(value=376)
    @Handler(priority=0x7FFFFFFE)
    public void motdEnd(ClientReceiveNumericEvent event) {
        this.motdMessages.add(event.getServerMessage());
        this.getClient().getServerInfo().setMotd(new ArrayList<String>(this.motd));
        this.fire(new ClientReceiveMotdEvent(this.getClient(), this.motdMessages));
    }
}

