/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import org.kitteh.irc.client.library.event.channel.ChannelNamesUpdatedEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.kitteh.irc.client.library.feature.filter.NumericFilter;

public class DefaultNamesListener
extends AbstractDefaultListenerBase {
    private final List<ServerMessage> namesMessages = new ArrayList<ServerMessage>();

    public DefaultNamesListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter(value=353)
    @Handler(priority=0x7FFFFFFE)
    public void names(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 4) {
            this.trackException(event, "NAMES response too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getChannel(event.getParameters().get(2));
        if (!channel.isPresent()) {
            this.trackException(event, "NAMES response sent for invalid channel name");
            return;
        }
        List<ChannelUserMode> channelUserModes = this.getClient().getServerInfo().getChannelUserModes();
        block0: for (String combo : event.getParameters().get(3).split(" ")) {
            HashSet<ChannelUserMode> modes = new HashSet<ChannelUserMode>();
            for (int i = 0; i < combo.length(); ++i) {
                char c = combo.charAt(i);
                Optional<ChannelUserMode> mode = channelUserModes.stream().filter(userMode -> userMode.getNickPrefix() == c).findFirst();
                if (!mode.isPresent()) {
                    this.getTracker().trackChannelNick(channel.get().getName(), combo.substring(i), modes);
                    continue block0;
                }
                modes.add(mode.get());
            }
        }
        this.namesMessages.add(event.getServerMessage());
    }

    @NumericFilter(value=366)
    @Handler(priority=0x7FFFFFFE)
    public void namesComplete(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "NAMES response too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getChannel(event.getParameters().get(1));
        if (!channel.isPresent()) {
            this.trackException(event, "NAMES response sent for invalid channel name");
            return;
        }
        this.namesMessages.add(event.getServerMessage());
        this.fire(new ChannelNamesUpdatedEvent(this.getClient(), this.namesMessages, channel.get()));
        this.namesMessages.clear();
    }
}

