/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.element;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.util.Cutter;
import org.kitteh.irc.client.library.util.StringUtil;

public interface MessageReceiver
extends Actor {
    public @NonNull String getMessagingName();

    default public @NonNull String getLowerCaseMessagingName() {
        return StringUtil.toLowerCase(this, this.getMessagingName());
    }

    default public void sendCtcpMessage(@NonNull String message) {
        this.getClient().sendCtcpMessage(this, message);
    }

    default public void sendMessage(@NonNull String message) {
        this.getClient().sendMessage(this, message);
    }

    default public void sendMultiLineMessage(@NonNull String message) {
        this.getClient().sendMultiLineMessage(this, message);
    }

    default public void sendMultiLineMessage(@NonNull String message, @NonNull Cutter cutter) {
        this.getClient().sendMultiLineMessage(this, message, cutter);
    }

    default public void sendNotice(@NonNull String message) {
        this.getClient().sendNotice(this, message);
    }

    default public void sendMultiLineNotice(@NonNull String message) {
        this.getClient().sendMultiLineNotice(this, message);
    }

    default public void sendMultiLineNotice(@NonNull String message, @NonNull Cutter cutter) {
        this.getClient().sendMultiLineNotice(this, message, cutter);
    }
}

