/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.abstractbase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.ClientEventBase;
import org.kitteh.irc.client.library.event.helper.ServerMultipleMessageEvent;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public abstract class ServerMultipleMessageEventBase
extends ClientEventBase
implements ServerMultipleMessageEvent {
    private final List<ServerMessage> sourceMessages;

    protected ServerMultipleMessageEventBase(@NonNull Client client, @NonNull List<ServerMessage> sourceMessages) {
        super(client);
        this.sourceMessages = Collections.unmodifiableList(new ArrayList(Sanity.nullCheck(sourceMessages, "Original messages")));
    }

    @Override
    public @NonNull List<ServerMessage> getSource() {
        return this.sourceMessages;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("sourceMessages", this.sourceMessages);
    }
}

