/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.CapabilityState;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.CapabilityNegotiationResponseEventBase;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class CapabilitiesDeletedSupportedEvent
extends CapabilityNegotiationResponseEventBase {
    private final List<CapabilityState> deletedCapabilities;

    public CapabilitiesDeletedSupportedEvent(@NonNull Client client, @NonNull ServerMessage sourceMessage, boolean negotiating, @NonNull List<CapabilityState> deletedCapabilities) {
        super(client, sourceMessage, negotiating);
        Sanity.nullCheck(deletedCapabilities, "Capabilities list");
        this.deletedCapabilities = Collections.unmodifiableList(new ArrayList<CapabilityState>(deletedCapabilities));
    }

    public @NonNull List<CapabilityState> getDeletedCapabilities() {
        return this.deletedCapabilities;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("deletedCapabilities", this.deletedCapabilities);
    }
}

