/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.channel;

import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.kitteh.irc.client.library.element.mode.ModeInfo;
import org.kitteh.irc.client.library.event.abstractbase.ChannelMultipleMessageEventBase;
import org.kitteh.irc.client.library.event.helper.ChannelEvent;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class ChannelModeInfoListEvent
extends ChannelMultipleMessageEventBase
implements ChannelEvent {
    private final ChannelMode mode;
    private final List<ModeInfo> info;

    public ChannelModeInfoListEvent(@NonNull Client client, @NonNull List<ServerMessage> sourceMessages, @NonNull Channel channel, @NonNull ChannelMode mode, @NonNull List<ModeInfo> info) {
        super(client, sourceMessages, channel);
        this.mode = Sanity.nullCheck(mode, "Mode");
        this.info = Collections.unmodifiableList(Sanity.nullCheck(info, "Info"));
    }

    public @NonNull ChannelMode getMode() {
        return this.mode;
    }

    public @NonNull List<ModeInfo> getModeInfo() {
        return this.info;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("mode", this.mode).add("info", this.info);
    }
}

