/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.user;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.Actor;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.element.mode.ModeStatusList;
import org.kitteh.irc.client.library.element.mode.UserMode;
import org.kitteh.irc.client.library.event.abstractbase.ActorEventBase;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class UserModeEvent
extends ActorEventBase<Actor> {
    private final ModeStatusList<UserMode> statusList;
    private final String target;

    public UserModeEvent(@NonNull Client client, @NonNull ServerMessage sourceMessage, @NonNull Actor actor, @NonNull String target, @NonNull ModeStatusList<UserMode> statusList) {
        super(client, sourceMessage, actor);
        this.statusList = Sanity.nullCheck(statusList, "Status list");
        this.target = Sanity.nullCheck(target, "Target");
    }

    public @NonNull ModeStatusList<UserMode> getStatusList() {
        return this.statusList;
    }

    @Override
    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("actor", this.getActor()).add("statusList", this.statusList).add("target", this.target).toString();
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("target", this.target).add("statusList", this.statusList);
    }
}

