/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.element.ISupportParameter;
import org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import org.kitteh.irc.client.library.element.mode.UserMode;
import org.kitteh.irc.client.library.feature.CaseMapping;
import org.kitteh.irc.client.library.util.Sanity;

public interface ServerInfo {
    public void addCustomChannelMode(@NonNull ChannelMode var1);

    public void addCustomUserMode(@NonNull UserMode var1);

    public @NonNull Optional<String> getAddress();

    default public int getAwayReasonLengthLimit() {
        Optional<ISupportParameter.AwayLen> optional = this.getISupportParameter("AWAYLEN", ISupportParameter.AwayLen.class);
        return optional.map(ISupportParameter.IntegerParameter::getInteger).orElse(-1);
    }

    default public @NonNull CaseMapping getCaseMapping() {
        Optional<ISupportParameter.CaseMapping> optional = this.getISupportParameter("CASEMAPPING", ISupportParameter.CaseMapping.class);
        return optional.map(ISupportParameter.CaseMapping::getCaseMapping).orElse(CaseMapping.RFC1459);
    }

    default public int getChannelLengthLimit() {
        Optional<ISupportParameter.ChannelLen> optional = this.getISupportParameter("CHANNELLEN", ISupportParameter.ChannelLen.class);
        return optional.map(ISupportParameter.IntegerParameter::getInteger).orElse(-1);
    }

    default public @NonNull Map<Character, Integer> getChannelLimits() {
        Optional<ISupportParameter.ChanLimit> optional = this.getISupportParameter("CHANLIMIT", ISupportParameter.ChanLimit.class);
        return optional.map(ISupportParameter.ChanLimit::getLimits).orElseGet(Collections::emptyMap);
    }

    default public @NonNull Optional<ChannelMode> getChannelMode(char character) {
        return this.getChannelModes().stream().filter(channelMode -> channelMode.getChar() == character).findFirst();
    }

    public @NonNull List<ChannelMode> getChannelModes();

    public @NonNull List<Character> getChannelPrefixes();

    default public @NonNull Optional<ChannelUserMode> getChannelUserMode(char character) {
        return this.getChannelUserModes().stream().filter(channelUserMode -> channelUserMode.getChar() == character).findFirst();
    }

    public @NonNull List<ChannelUserMode> getChannelUserModes();

    public @NonNull Optional<ISupportParameter> getISupportParameter(@NonNull String var1);

    default public <ISupport extends ISupportParameter> @NonNull Optional<ISupport> getISupportParameter(@NonNull String name, @NonNull Class<ISupport> clazz) {
        Optional<ISupportParameter> optional = this.getISupportParameter(name);
        if (optional.isPresent() && Sanity.nullCheck(clazz, "Class").isInstance(optional.get())) {
            return optional;
        }
        return Optional.empty();
    }

    public @NonNull Map<String, ISupportParameter> getISupportParameters();

    default public int getKickReasonLengthLimit() {
        Optional<ISupportParameter.KickLen> optional = this.getISupportParameter("KICKLEN", ISupportParameter.KickLen.class);
        return optional.map(ISupportParameter.IntegerParameter::getInteger).orElse(-1);
    }

    public @NonNull Optional<List<String>> getMotd();

    default public @NonNull Optional<String> getNetworkName() {
        Optional<ISupportParameter.Network> optional = this.getISupportParameter("NETWORK", ISupportParameter.Network.class);
        return optional.map(ISupportParameter.Network::getNetworkName);
    }

    default public int getNickLengthLimit() {
        Optional<ISupportParameter.NickLen> optional = this.getISupportParameter("NICKLEN", ISupportParameter.NickLen.class);
        return optional.map(ISupportParameter.IntegerParameter::getInteger).orElse(-1);
    }

    default public int getTopicLengthLimit() {
        Optional<ISupportParameter.TopicLen> optional = this.getISupportParameter("TOPICLEN", ISupportParameter.TopicLen.class);
        return optional.map(ISupportParameter.IntegerParameter::getInteger).orElse(-1);
    }

    public @NonNull List<UserMode> getUserModes();

    public @NonNull Optional<String> getVersion();

    default public boolean hasWhoXSupport() {
        return this.getISupportParameter("WHOX").isPresent();
    }

    public boolean isValidChannel(@NonNull String var1);

    public static interface WithManagement
    extends ServerInfo {
        public void addISupportParameter(@NonNull ISupportParameter var1);

        public @NonNull Optional<ChannelUserMode> getTargetedChannelInfo(@NonNull String var1);

        public void setAddress(@NonNull String var1);

        public void setMotd(@NonNull List<String> var1);

        public void setUserModes(@NonNull List<UserMode> var1);

        public void setVersion(@NonNull String var1);
    }
}

