/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.auth;

import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.CapabilityRequestCommand;
import org.kitteh.irc.client.library.element.CapabilityState;
import org.kitteh.irc.client.library.event.capabilities.CapabilitiesAcknowledgedEvent;
import org.kitteh.irc.client.library.event.capabilities.CapabilitiesRejectedEvent;
import org.kitteh.irc.client.library.event.capabilities.CapabilitiesSupportedListEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.kitteh.irc.client.library.event.helper.CapabilityNegotiationResponseEvent;
import org.kitteh.irc.client.library.feature.auth.AbstractAuthProtocol;
import org.kitteh.irc.client.library.feature.auth.element.EventListening;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.kitteh.irc.client.library.feature.filter.NumericFilter;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public abstract class AbstractSaslProtocol
extends AbstractAuthProtocol
implements EventListening {
    private Listener listener;
    private final String saslType;
    private volatile boolean authenticating = false;

    protected AbstractSaslProtocol(@NonNull Client client, @NonNull String saslType) {
        super(client);
        this.saslType = Sanity.nullCheck(saslType, "SASL type");
    }

    @Override
    protected final @NonNull String getAuthentication() {
        return "AUTHENTICATE " + this.saslType;
    }

    @Override
    public @NonNull Object getEventListener() {
        return this.listener == null ? (this.listener = new Listener()) : this.listener;
    }

    protected abstract @NonNull String getAuthLine();

    @Override
    protected void toString(ToStringer stringer) {
        stringer.add("type", this.saslType);
    }

    protected class Listener {
        protected Listener() {
        }

        @Handler(priority=1)
        public void capList(CapabilitiesSupportedListEvent event) {
            if (event.isNegotiating() && !AbstractSaslProtocol.this.authenticating) {
                Optional<CapabilityState> state = event.getSupportedCapabilities().stream().filter(c -> c.getName().equalsIgnoreCase("sasl")).findFirst();
                if (!state.isPresent()) {
                    return;
                }
                Optional<String> stateValue = state.get().getValue();
                if (stateValue.isPresent() && Arrays.stream(stateValue.get().split(",")).noneMatch(mechanism -> mechanism.equalsIgnoreCase(AbstractSaslProtocol.this.saslType))) {
                    return;
                }
                new CapabilityRequestCommand(AbstractSaslProtocol.this.getClient()).enable("sasl").execute();
                event.setEndingNegotiation(false);
                AbstractSaslProtocol.this.authenticating = true;
            }
        }

        @Handler(priority=1)
        public void capAck(CapabilitiesAcknowledgedEvent event) {
            if (event.getAcknowledgedCapabilities().stream().anyMatch(c -> c.getName().equalsIgnoreCase("sasl"))) {
                AbstractSaslProtocol.this.startAuthentication();
            }
        }

        @Handler(priority=1)
        public void capNak(CapabilitiesRejectedEvent event) {
            if (event.getRejectedCapabilitiesRequest().stream().anyMatch(c -> c.getName().equalsIgnoreCase("sasl"))) {
                AbstractSaslProtocol.this.authenticating = false;
            }
        }

        @Handler
        public void capEndable(CapabilityNegotiationResponseEvent event) {
            if (AbstractSaslProtocol.this.authenticating) {
                event.setEndingNegotiation(false);
            }
        }

        @CommandFilter(value="AUTHENTICATE")
        @Handler
        public void authenticate(ClientReceiveCommandEvent event) {
            if (!event.getParameters().isEmpty()) {
                String base64 = Base64.getEncoder().encodeToString(AbstractSaslProtocol.this.getAuthLine().getBytes());
                AbstractSaslProtocol.this.getClient().sendRawLineImmediately("AUTHENTICATE " + base64);
            }
        }

        @NumericFilter(value=900)
        @Handler
        public void loggedIn(ClientReceiveNumericEvent event) {
        }

        @NumericFilter(value=903)
        @Handler
        public void success(ClientReceiveNumericEvent event) {
            this.finish();
        }

        @NumericFilter.Numerics(value={@NumericFilter(value=902), @NumericFilter(value=904), @NumericFilter(value=905), @NumericFilter(value=906), @NumericFilter(value=907), @NumericFilter(value=908)})
        @Handler
        public void fail(ClientReceiveNumericEvent event) {
            this.finish();
        }

        private void finish() {
            AbstractSaslProtocol.this.authenticating = false;
            AbstractSaslProtocol.this.getClient().sendRawLineImmediately("CAP END");
        }

        public @NonNull String toString() {
            return new ToStringer(this).toString();
        }
    }
}

