/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.auth;

import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import org.kitteh.irc.client.library.feature.auth.AbstractAccountPassProtocol;
import org.kitteh.irc.client.library.feature.auth.element.EventListening;
import org.kitteh.irc.client.library.feature.filter.NumericFilter;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class GameSurge
extends AbstractAccountPassProtocol
implements EventListening {
    private final Listener listener = new Listener();

    public GameSurge(@NonNull Client client, @NonNull String accountName, @NonNull String password) {
        super(client, Sanity.safeMessageCheck(accountName, "Account name"), password);
    }

    @Override
    protected @NonNull String getAuthentication() {
        return "PRIVMSG AuthServ@services.gamesurge.net :auth " + this.getAccountName() + ' ' + this.getPassword();
    }

    @Override
    public @NonNull Object getEventListener() {
        return this.listener;
    }

    private class Listener {
        private Listener() {
        }

        @NumericFilter(value=4)
        @Handler
        public void listenVersion(ClientReceiveNumericEvent event) {
            GameSurge.this.startAuthentication();
        }

        public @NonNull String toString() {
            return new ToStringer(this).toString();
        }
    }
}

