/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.twitch;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.CapabilityState;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.event.capabilities.CapabilitiesSupportedListEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.exception.KittehServerMessageException;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.kitteh.irc.client.library.feature.twitch.event.ClearChatEvent;
import org.kitteh.irc.client.library.feature.twitch.event.GlobalUserStateEvent;
import org.kitteh.irc.client.library.feature.twitch.event.RoomStateEvent;
import org.kitteh.irc.client.library.feature.twitch.event.UserNoticeEvent;
import org.kitteh.irc.client.library.feature.twitch.event.UserStateEvent;
import org.kitteh.irc.client.library.feature.twitch.event.WhisperEvent;
import org.kitteh.irc.client.library.util.Sanity;

public class TwitchListener {
    private final Client client;

    public TwitchListener(@NonNull Client client) {
        this.client = Sanity.nullCheck(client, "Client");
    }

    @Handler
    public void capList(@NonNull CapabilitiesSupportedListEvent event) {
        List already = this.client.getCapabilityManager().getCapabilities().stream().map(CapabilityState::getName).collect(Collectors.toList());
        if (!already.contains("twitch.tv/commands")) {
            event.addRequest("twitch.tv/commands");
        }
        if (!already.contains("twitch.tv/membership")) {
            event.addRequest("twitch.tv/membership");
        }
        if (!already.contains("twitch.tv/tags")) {
            event.addRequest("twitch.tv/tags");
        }
    }

    @CommandFilter(value="CLEARCHAT")
    @Handler(priority=0x7FFFFFFD)
    public void clearChat(ClientReceiveCommandEvent event) {
        this.client.getEventManager().callEvent(new ClearChatEvent(this.client, event.getSource(), this.getChannel(event)));
    }

    @CommandFilter(value="GLOBALUSERSTATE")
    @Handler(priority=0x7FFFFFFD)
    public void globalUserState(ClientReceiveCommandEvent event) {
        this.client.getEventManager().callEvent(new GlobalUserStateEvent(this.client, event.getSource()));
    }

    @CommandFilter(value="ROOMSTATE")
    @Handler(priority=0x7FFFFFFD)
    public void roomState(ClientReceiveCommandEvent event) {
        this.client.getEventManager().callEvent(new RoomStateEvent(this.client, event.getSource(), this.getChannel(event)));
    }

    @CommandFilter(value="USERNOTICE")
    @Handler(priority=0x7FFFFFFD)
    public void userNotice(ClientReceiveCommandEvent event) {
        String message = null;
        if (event.getParameters().size() > 1) {
            message = event.getParameters().get(1);
        }
        this.client.getEventManager().callEvent(new UserNoticeEvent(this.client, event.getSource(), this.getChannel(event), message));
    }

    @CommandFilter(value="USERSTATE")
    @Handler(priority=0x7FFFFFFD)
    public void userState(ClientReceiveCommandEvent event) {
        this.client.getEventManager().callEvent(new UserStateEvent(this.client, event.getSource(), this.getChannel(event)));
    }

    @CommandFilter(value="WHISPER")
    @Handler(priority=0x7FFFFFFD)
    public void whisper(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.client.getExceptionListener().queue(new KittehServerMessageException(event.getSource(), "WHISPER didn't contain enough parameters"));
            return;
        }
        if (!(event.getActor() instanceof User)) {
            this.client.getExceptionListener().queue(new KittehServerMessageException(event.getSource(), "Received WHISPER from non-user"));
            return;
        }
        String target = event.getParameters().get(0);
        String message = event.getParameters().get(1);
        User sender = (User)event.getActor();
        this.client.getEventManager().callEvent(new WhisperEvent(this.client, event.getSource(), sender, target, message));
    }

    private @NonNull Channel getChannel(ClientReceiveCommandEvent event) {
        Optional<Channel> channel = this.client.getChannel(event.getParameters().get(0));
        if (!channel.isPresent()) {
            throw new KittehServerMessageException(event.getServerMessage(), "Invalid channel name");
        }
        return channel.get();
    }
}

